package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.{IdentityStoreId, ResourceId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateGroupMembershipResponse(
    membershipId: ResourceId,
    identityStoreId: IdentityStoreId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.CreateGroupMembershipResponse = {
    import CreateGroupMembershipResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.CreateGroupMembershipResponse
      .builder()
      .membershipId(ResourceId.unwrap(membershipId): java.lang.String)
      .identityStoreId(
        IdentityStoreId.unwrap(identityStoreId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.identitystore.model.CreateGroupMembershipResponse.ReadOnly =
    zio.aws.identitystore.model.CreateGroupMembershipResponse
      .wrap(buildAwsValue())
}
object CreateGroupMembershipResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.CreateGroupMembershipResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.CreateGroupMembershipResponse =
      zio.aws.identitystore.model
        .CreateGroupMembershipResponse(membershipId, identityStoreId)
    def membershipId: ResourceId
    def identityStoreId: IdentityStoreId
    def getMembershipId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(membershipId)
    def getIdentityStoreId: ZIO[Any, Nothing, IdentityStoreId] =
      ZIO.succeed(identityStoreId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.CreateGroupMembershipResponse
  ) extends zio.aws.identitystore.model.CreateGroupMembershipResponse.ReadOnly {
    override val membershipId: ResourceId =
      zio.aws.identitystore.model.primitives.ResourceId(impl.membershipId())
    override val identityStoreId: IdentityStoreId =
      zio.aws.identitystore.model.primitives
        .IdentityStoreId(impl.identityStoreId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.CreateGroupMembershipResponse
  ): zio.aws.identitystore.model.CreateGroupMembershipResponse.ReadOnly =
    new Wrapper(impl)
}
