package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListGroupMembershipsResponse(
    groupMemberships: Iterable[zio.aws.identitystore.model.GroupMembership],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsResponse = {
    import ListGroupMembershipsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsResponse
      .builder()
      .groupMemberships(groupMemberships.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.identitystore.model.ListGroupMembershipsResponse.ReadOnly =
    zio.aws.identitystore.model.ListGroupMembershipsResponse
      .wrap(buildAwsValue())
}
object ListGroupMembershipsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.ListGroupMembershipsResponse =
      zio.aws.identitystore.model.ListGroupMembershipsResponse(
        groupMemberships.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def groupMemberships
        : List[zio.aws.identitystore.model.GroupMembership.ReadOnly]
    def nextToken: Optional[NextToken]
    def getGroupMemberships: ZIO[Any, Nothing, List[
      zio.aws.identitystore.model.GroupMembership.ReadOnly
    ]] = ZIO.succeed(groupMemberships)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsResponse
  ) extends zio.aws.identitystore.model.ListGroupMembershipsResponse.ReadOnly {
    override val groupMemberships
        : List[zio.aws.identitystore.model.GroupMembership.ReadOnly] = impl
      .groupMemberships()
      .asScala
      .map { item =>
        zio.aws.identitystore.model.GroupMembership.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.identitystore.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsResponse
  ): zio.aws.identitystore.model.ListGroupMembershipsResponse.ReadOnly =
    new Wrapper(impl)
}
