package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.{ResourceId, IdentityStoreId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeGroupRequest(
    identityStoreId: IdentityStoreId,
    groupId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.DescribeGroupRequest = {
    import DescribeGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.DescribeGroupRequest
      .builder()
      .identityStoreId(
        IdentityStoreId.unwrap(identityStoreId): java.lang.String
      )
      .groupId(ResourceId.unwrap(groupId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.DescribeGroupRequest.ReadOnly =
    zio.aws.identitystore.model.DescribeGroupRequest.wrap(buildAwsValue())
}
object DescribeGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.DescribeGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.DescribeGroupRequest =
      zio.aws.identitystore.model.DescribeGroupRequest(identityStoreId, groupId)
    def identityStoreId: IdentityStoreId
    def groupId: ResourceId
    def getIdentityStoreId: ZIO[Any, Nothing, IdentityStoreId] =
      ZIO.succeed(identityStoreId)
    def getGroupId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(groupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.DescribeGroupRequest
  ) extends zio.aws.identitystore.model.DescribeGroupRequest.ReadOnly {
    override val identityStoreId: IdentityStoreId =
      zio.aws.identitystore.model.primitives
        .IdentityStoreId(impl.identityStoreId())
    override val groupId: ResourceId =
      zio.aws.identitystore.model.primitives.ResourceId(impl.groupId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.DescribeGroupRequest
  ): zio.aws.identitystore.model.DescribeGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
