package zio.aws.identitystore.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.identitystore.model.primitives.{
  NextToken,
  MaxResults,
  IdentityStoreId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListGroupMembershipsForMemberRequest(
    identityStoreId: IdentityStoreId,
    memberId: zio.aws.identitystore.model.MemberId,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsForMemberRequest = {
    import ListGroupMembershipsForMemberRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsForMemberRequest
      .builder()
      .identityStoreId(
        IdentityStoreId.unwrap(identityStoreId): java.lang.String
      )
      .memberId(memberId.buildAwsValue())
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.identitystore.model.ListGroupMembershipsForMemberRequest.ReadOnly =
    zio.aws.identitystore.model.ListGroupMembershipsForMemberRequest
      .wrap(buildAwsValue())
}
object ListGroupMembershipsForMemberRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsForMemberRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.identitystore.model.ListGroupMembershipsForMemberRequest =
      zio.aws.identitystore.model.ListGroupMembershipsForMemberRequest(
        identityStoreId,
        memberId.asEditable,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def identityStoreId: IdentityStoreId
    def memberId: zio.aws.identitystore.model.MemberId.ReadOnly
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getIdentityStoreId: ZIO[Any, Nothing, IdentityStoreId] =
      ZIO.succeed(identityStoreId)
    def getMemberId
        : ZIO[Any, Nothing, zio.aws.identitystore.model.MemberId.ReadOnly] =
      ZIO.succeed(memberId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsForMemberRequest
  ) extends zio.aws.identitystore.model.ListGroupMembershipsForMemberRequest.ReadOnly {
    override val identityStoreId: IdentityStoreId =
      zio.aws.identitystore.model.primitives
        .IdentityStoreId(impl.identityStoreId())
    override val memberId: zio.aws.identitystore.model.MemberId.ReadOnly =
      zio.aws.identitystore.model.MemberId.wrap(impl.memberId())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.identitystore.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.identitystore.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsForMemberRequest
  ): zio.aws.identitystore.model.ListGroupMembershipsForMemberRequest.ReadOnly =
    new Wrapper(impl)
}
