package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.{
  IdentityStoreId,
  SensitiveStringType,
  GroupDisplayName,
  ResourceId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Group(
    groupId: ResourceId,
    displayName: Optional[GroupDisplayName] = Optional.Absent,
    externalIds: Optional[Iterable[zio.aws.identitystore.model.ExternalId]] =
      Optional.Absent,
    description: Optional[SensitiveStringType] = Optional.Absent,
    identityStoreId: IdentityStoreId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.Group = {
    import Group.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.Group
      .builder()
      .groupId(ResourceId.unwrap(groupId): java.lang.String)
      .optionallyWith(
        displayName.map(value =>
          GroupDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        externalIds.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.externalIds)
      .optionallyWith(
        description.map(value =>
          SensitiveStringType.unwrap(value): java.lang.String
        )
      )(_.description)
      .identityStoreId(
        IdentityStoreId.unwrap(identityStoreId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.Group.ReadOnly =
    zio.aws.identitystore.model.Group.wrap(buildAwsValue())
}
object Group {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.Group
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.Group =
      zio.aws.identitystore.model.Group(
        groupId,
        displayName.map(value => value),
        externalIds.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        description.map(value => value),
        identityStoreId
      )
    def groupId: ResourceId
    def displayName: Optional[GroupDisplayName]
    def externalIds
        : Optional[List[zio.aws.identitystore.model.ExternalId.ReadOnly]]
    def description: Optional[SensitiveStringType]
    def identityStoreId: IdentityStoreId
    def getGroupId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(groupId)
    def getDisplayName: ZIO[Any, AwsError, GroupDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getExternalIds: ZIO[Any, AwsError, List[
      zio.aws.identitystore.model.ExternalId.ReadOnly
    ]] = AwsError.unwrapOptionField("externalIds", externalIds)
    def getDescription: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("description", description)
    def getIdentityStoreId: ZIO[Any, Nothing, IdentityStoreId] =
      ZIO.succeed(identityStoreId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.Group
  ) extends zio.aws.identitystore.model.Group.ReadOnly {
    override val groupId: ResourceId =
      zio.aws.identitystore.model.primitives.ResourceId(impl.groupId())
    override val displayName: Optional[GroupDisplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value =>
        zio.aws.identitystore.model.primitives.GroupDisplayName(value)
      )
    override val externalIds
        : Optional[List[zio.aws.identitystore.model.ExternalId.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.externalIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.identitystore.model.ExternalId.wrap(item)
          }.toList
        )
    override val description: Optional[SensitiveStringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.identitystore.model.primitives.SensitiveStringType(value)
        )
    override val identityStoreId: IdentityStoreId =
      zio.aws.identitystore.model.primitives
        .IdentityStoreId(impl.identityStoreId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.Group
  ): zio.aws.identitystore.model.Group.ReadOnly = new Wrapper(impl)
}
