package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.{
  ExternalIdIdentifier,
  ExternalIdIssuer
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ExternalId(
    issuer: ExternalIdIssuer,
    id: ExternalIdIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.ExternalId = {
    import ExternalId.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.ExternalId
      .builder()
      .issuer(ExternalIdIssuer.unwrap(issuer): java.lang.String)
      .id(ExternalIdIdentifier.unwrap(id): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.ExternalId.ReadOnly =
    zio.aws.identitystore.model.ExternalId.wrap(buildAwsValue())
}
object ExternalId {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.ExternalId
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.ExternalId =
      zio.aws.identitystore.model.ExternalId(issuer, id)
    def issuer: ExternalIdIssuer
    def id: ExternalIdIdentifier
    def getIssuer: ZIO[Any, Nothing, ExternalIdIssuer] = ZIO.succeed(issuer)
    def getId: ZIO[Any, Nothing, ExternalIdIdentifier] = ZIO.succeed(id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.ExternalId
  ) extends zio.aws.identitystore.model.ExternalId.ReadOnly {
    override val issuer: ExternalIdIssuer =
      zio.aws.identitystore.model.primitives.ExternalIdIssuer(impl.issuer())
    override val id: ExternalIdIdentifier =
      zio.aws.identitystore.model.primitives.ExternalIdIdentifier(impl.id())
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.ExternalId
  ): zio.aws.identitystore.model.ExternalId.ReadOnly = new Wrapper(impl)
}
