package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.{ResourceId, IdentityStoreId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteGroupMembershipRequest(
    identityStoreId: IdentityStoreId,
    membershipId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.DeleteGroupMembershipRequest = {
    import DeleteGroupMembershipRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.DeleteGroupMembershipRequest
      .builder()
      .identityStoreId(
        IdentityStoreId.unwrap(identityStoreId): java.lang.String
      )
      .membershipId(ResourceId.unwrap(membershipId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.identitystore.model.DeleteGroupMembershipRequest.ReadOnly =
    zio.aws.identitystore.model.DeleteGroupMembershipRequest
      .wrap(buildAwsValue())
}
object DeleteGroupMembershipRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.DeleteGroupMembershipRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.DeleteGroupMembershipRequest =
      zio.aws.identitystore.model
        .DeleteGroupMembershipRequest(identityStoreId, membershipId)
    def identityStoreId: IdentityStoreId
    def membershipId: ResourceId
    def getIdentityStoreId: ZIO[Any, Nothing, IdentityStoreId] =
      ZIO.succeed(identityStoreId)
    def getMembershipId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(membershipId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.DeleteGroupMembershipRequest
  ) extends zio.aws.identitystore.model.DeleteGroupMembershipRequest.ReadOnly {
    override val identityStoreId: IdentityStoreId =
      zio.aws.identitystore.model.primitives
        .IdentityStoreId(impl.identityStoreId())
    override val membershipId: ResourceId =
      zio.aws.identitystore.model.primitives.ResourceId(impl.membershipId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.DeleteGroupMembershipRequest
  ): zio.aws.identitystore.model.DeleteGroupMembershipRequest.ReadOnly =
    new Wrapper(impl)
}
