package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListGroupMembershipsForMemberResponse(
    groupMemberships: Iterable[zio.aws.identitystore.model.GroupMembership],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsForMemberResponse = {
    import ListGroupMembershipsForMemberResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsForMemberResponse
      .builder()
      .groupMemberships(groupMemberships.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.identitystore.model.ListGroupMembershipsForMemberResponse.ReadOnly =
    zio.aws.identitystore.model.ListGroupMembershipsForMemberResponse
      .wrap(buildAwsValue())
}
object ListGroupMembershipsForMemberResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsForMemberResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.identitystore.model.ListGroupMembershipsForMemberResponse =
      zio.aws.identitystore.model.ListGroupMembershipsForMemberResponse(
        groupMemberships.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def groupMemberships
        : List[zio.aws.identitystore.model.GroupMembership.ReadOnly]
    def nextToken: Optional[NextToken]
    def getGroupMemberships: ZIO[Any, Nothing, List[
      zio.aws.identitystore.model.GroupMembership.ReadOnly
    ]] = ZIO.succeed(groupMemberships)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsForMemberResponse
  ) extends zio.aws.identitystore.model.ListGroupMembershipsForMemberResponse.ReadOnly {
    override val groupMemberships
        : List[zio.aws.identitystore.model.GroupMembership.ReadOnly] = impl
      .groupMemberships()
      .asScala
      .map { item =>
        zio.aws.identitystore.model.GroupMembership.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.identitystore.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsForMemberResponse
  ): zio.aws.identitystore.model.ListGroupMembershipsForMemberResponse.ReadOnly =
    new Wrapper(impl)
}
