package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.{ResourceId, IdentityStoreId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeGroupMembershipResponse(
    identityStoreId: IdentityStoreId,
    membershipId: ResourceId,
    groupId: ResourceId,
    memberId: zio.aws.identitystore.model.MemberId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.DescribeGroupMembershipResponse = {
    import DescribeGroupMembershipResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.DescribeGroupMembershipResponse
      .builder()
      .identityStoreId(
        IdentityStoreId.unwrap(identityStoreId): java.lang.String
      )
      .membershipId(ResourceId.unwrap(membershipId): java.lang.String)
      .groupId(ResourceId.unwrap(groupId): java.lang.String)
      .memberId(memberId.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.identitystore.model.DescribeGroupMembershipResponse.ReadOnly =
    zio.aws.identitystore.model.DescribeGroupMembershipResponse
      .wrap(buildAwsValue())
}
object DescribeGroupMembershipResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.DescribeGroupMembershipResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.identitystore.model.DescribeGroupMembershipResponse =
      zio.aws.identitystore.model.DescribeGroupMembershipResponse(
        identityStoreId,
        membershipId,
        groupId,
        memberId.asEditable
      )
    def identityStoreId: IdentityStoreId
    def membershipId: ResourceId
    def groupId: ResourceId
    def memberId: zio.aws.identitystore.model.MemberId.ReadOnly
    def getIdentityStoreId: ZIO[Any, Nothing, IdentityStoreId] =
      ZIO.succeed(identityStoreId)
    def getMembershipId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(membershipId)
    def getGroupId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(groupId)
    def getMemberId
        : ZIO[Any, Nothing, zio.aws.identitystore.model.MemberId.ReadOnly] =
      ZIO.succeed(memberId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.DescribeGroupMembershipResponse
  ) extends zio.aws.identitystore.model.DescribeGroupMembershipResponse.ReadOnly {
    override val identityStoreId: IdentityStoreId =
      zio.aws.identitystore.model.primitives
        .IdentityStoreId(impl.identityStoreId())
    override val membershipId: ResourceId =
      zio.aws.identitystore.model.primitives.ResourceId(impl.membershipId())
    override val groupId: ResourceId =
      zio.aws.identitystore.model.primitives.ResourceId(impl.groupId())
    override val memberId: zio.aws.identitystore.model.MemberId.ReadOnly =
      zio.aws.identitystore.model.MemberId.wrap(impl.memberId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.DescribeGroupMembershipResponse
  ): zio.aws.identitystore.model.DescribeGroupMembershipResponse.ReadOnly =
    new Wrapper(impl)
}
