package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.{
  SensitiveBooleanType,
  SensitiveStringType
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Address(
    streetAddress: Optional[SensitiveStringType] = Optional.Absent,
    locality: Optional[SensitiveStringType] = Optional.Absent,
    region: Optional[SensitiveStringType] = Optional.Absent,
    postalCode: Optional[SensitiveStringType] = Optional.Absent,
    country: Optional[SensitiveStringType] = Optional.Absent,
    formatted: Optional[SensitiveStringType] = Optional.Absent,
    `type`: Optional[SensitiveStringType] = Optional.Absent,
    primary: Optional[SensitiveBooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.Address = {
    import Address.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.Address
      .builder()
      .optionallyWith(
        streetAddress.map(value =>
          SensitiveStringType.unwrap(value): java.lang.String
        )
      )(_.streetAddress)
      .optionallyWith(
        locality.map(value =>
          SensitiveStringType.unwrap(value): java.lang.String
        )
      )(_.locality)
      .optionallyWith(
        region.map(value => SensitiveStringType.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(
        postalCode.map(value =>
          SensitiveStringType.unwrap(value): java.lang.String
        )
      )(_.postalCode)
      .optionallyWith(
        country.map(value =>
          SensitiveStringType.unwrap(value): java.lang.String
        )
      )(_.country)
      .optionallyWith(
        formatted.map(value =>
          SensitiveStringType.unwrap(value): java.lang.String
        )
      )(_.formatted)
      .optionallyWith(
        `type`.map(value => SensitiveStringType.unwrap(value): java.lang.String)
      )(_.`type`)
      .optionallyWith(
        primary.map(value =>
          SensitiveBooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.primary)
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.Address.ReadOnly =
    zio.aws.identitystore.model.Address.wrap(buildAwsValue())
}
object Address {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.Address
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.Address =
      zio.aws.identitystore.model.Address(
        streetAddress.map(value => value),
        locality.map(value => value),
        region.map(value => value),
        postalCode.map(value => value),
        country.map(value => value),
        formatted.map(value => value),
        `type`.map(value => value),
        primary.map(value => value)
      )
    def streetAddress: Optional[SensitiveStringType]
    def locality: Optional[SensitiveStringType]
    def region: Optional[SensitiveStringType]
    def postalCode: Optional[SensitiveStringType]
    def country: Optional[SensitiveStringType]
    def formatted: Optional[SensitiveStringType]
    def `type`: Optional[SensitiveStringType]
    def primary: Optional[SensitiveBooleanType]
    def getStreetAddress: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("streetAddress", streetAddress)
    def getLocality: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("locality", locality)
    def getRegion: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("region", region)
    def getPostalCode: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("postalCode", postalCode)
    def getCountry: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("country", country)
    def getFormatted: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("formatted", formatted)
    def getType: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("type", `type`)
    def getPrimary: ZIO[Any, AwsError, SensitiveBooleanType] =
      AwsError.unwrapOptionField("primary", primary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.Address
  ) extends zio.aws.identitystore.model.Address.ReadOnly {
    override val streetAddress: Optional[SensitiveStringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.streetAddress())
        .map(value =>
          zio.aws.identitystore.model.primitives.SensitiveStringType(value)
        )
    override val locality: Optional[SensitiveStringType] = zio.aws.core.internal
      .optionalFromNullable(impl.locality())
      .map(value =>
        zio.aws.identitystore.model.primitives.SensitiveStringType(value)
      )
    override val region: Optional[SensitiveStringType] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value =>
        zio.aws.identitystore.model.primitives.SensitiveStringType(value)
      )
    override val postalCode: Optional[SensitiveStringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.postalCode())
        .map(value =>
          zio.aws.identitystore.model.primitives.SensitiveStringType(value)
        )
    override val country: Optional[SensitiveStringType] = zio.aws.core.internal
      .optionalFromNullable(impl.country())
      .map(value =>
        zio.aws.identitystore.model.primitives.SensitiveStringType(value)
      )
    override val formatted: Optional[SensitiveStringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.formatted())
        .map(value =>
          zio.aws.identitystore.model.primitives.SensitiveStringType(value)
        )
    override val `type`: Optional[SensitiveStringType] = zio.aws.core.internal
      .optionalFromNullable(impl.`type`())
      .map(value =>
        zio.aws.identitystore.model.primitives.SensitiveStringType(value)
      )
    override val primary: Optional[SensitiveBooleanType] = zio.aws.core.internal
      .optionalFromNullable(impl.primary())
      .map(value =>
        zio.aws.identitystore.model.primitives.SensitiveBooleanType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.Address
  ): zio.aws.identitystore.model.Address.ReadOnly = new Wrapper(impl)
}
