package zio.aws.identitystore
import software.amazon.awssdk.core.document.Document
import zio.prelude.Subtype
import zio.aws.identitystore.model.primitives.ResourceId
import zio.aws.identitystore.model.primitives.AttributePath.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AttributePath extends Subtype[String]
    type AttributePath =
      zio.aws.identitystore.model.primitives.AttributePath.Type
    object ExternalIdIdentifier extends Subtype[String]
    type ExternalIdIdentifier =
      zio.aws.identitystore.model.primitives.ExternalIdIdentifier.Type
    object ExternalIdIssuer extends Subtype[String]
    type ExternalIdIssuer =
      zio.aws.identitystore.model.primitives.ExternalIdIssuer.Type
    object GroupDisplayName extends Subtype[String]
    type GroupDisplayName =
      zio.aws.identitystore.model.primitives.GroupDisplayName.Type
    object IdentityStoreId extends Subtype[String]
    type IdentityStoreId =
      zio.aws.identitystore.model.primitives.IdentityStoreId.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.identitystore.model.primitives.MaxResults.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.identitystore.model.primitives.NextToken.Type
    object ResourceId extends Subtype[String]
    type ResourceId = zio.aws.identitystore.model.primitives.ResourceId.Type
    object SensitiveBooleanType extends Subtype[Boolean]
    type SensitiveBooleanType =
      zio.aws.identitystore.model.primitives.SensitiveBooleanType.Type
    object SensitiveStringType extends Subtype[String]
    type SensitiveStringType =
      zio.aws.identitystore.model.primitives.SensitiveStringType.Type
    object UserName extends Subtype[String]
    type UserName = zio.aws.identitystore.model.primitives.UserName.Type
  }
  type Addresses = List[zio.aws.identitystore.model.Address]
  type AttributeOperations =
    List[zio.aws.identitystore.model.AttributeOperation]
  type AttributeValue = Document
  type Emails = List[zio.aws.identitystore.model.Email]
  type ExternalIds = List[zio.aws.identitystore.model.ExternalId]
  type Filters = List[zio.aws.identitystore.model.Filter]
  type GroupIds = List[ResourceId]
  type GroupMembershipExistenceResults =
    List[zio.aws.identitystore.model.GroupMembershipExistenceResult]
  type GroupMemberships = List[zio.aws.identitystore.model.GroupMembership]
  type Groups = List[zio.aws.identitystore.model.Group]
  type PhoneNumbers = List[zio.aws.identitystore.model.PhoneNumber]
  type Users = List[zio.aws.identitystore.model.User]
}
