package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListGroupsResponse(
    groups: Iterable[zio.aws.identitystore.model.Group],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.ListGroupsResponse = {
    import ListGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.ListGroupsResponse
      .builder()
      .groups(groups.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.ListGroupsResponse.ReadOnly =
    zio.aws.identitystore.model.ListGroupsResponse.wrap(buildAwsValue())
}
object ListGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.ListGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.ListGroupsResponse =
      zio.aws.identitystore.model.ListGroupsResponse(
        groups.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def groups: List[zio.aws.identitystore.model.Group.ReadOnly]
    def nextToken: Optional[NextToken]
    def getGroups
        : ZIO[Any, Nothing, List[zio.aws.identitystore.model.Group.ReadOnly]] =
      ZIO.succeed(groups)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.ListGroupsResponse
  ) extends zio.aws.identitystore.model.ListGroupsResponse.ReadOnly {
    override val groups: List[zio.aws.identitystore.model.Group.ReadOnly] = impl
      .groups()
      .asScala
      .map { item =>
        zio.aws.identitystore.model.Group.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.identitystore.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.ListGroupsResponse
  ): zio.aws.identitystore.model.ListGroupsResponse.ReadOnly = new Wrapper(impl)
}
