package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.IdentityStoreId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetUserIdRequest(
    identityStoreId: IdentityStoreId,
    alternateIdentifier: zio.aws.identitystore.model.AlternateIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.GetUserIdRequest = {
    import GetUserIdRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.GetUserIdRequest
      .builder()
      .identityStoreId(
        IdentityStoreId.unwrap(identityStoreId): java.lang.String
      )
      .alternateIdentifier(alternateIdentifier.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.GetUserIdRequest.ReadOnly =
    zio.aws.identitystore.model.GetUserIdRequest.wrap(buildAwsValue())
}
object GetUserIdRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.GetUserIdRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.GetUserIdRequest =
      zio.aws.identitystore.model
        .GetUserIdRequest(identityStoreId, alternateIdentifier.asEditable)
    def identityStoreId: IdentityStoreId
    def alternateIdentifier
        : zio.aws.identitystore.model.AlternateIdentifier.ReadOnly
    def getIdentityStoreId: ZIO[Any, Nothing, IdentityStoreId] =
      ZIO.succeed(identityStoreId)
    def getAlternateIdentifier: ZIO[
      Any,
      Nothing,
      zio.aws.identitystore.model.AlternateIdentifier.ReadOnly
    ] = ZIO.succeed(alternateIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.GetUserIdRequest
  ) extends zio.aws.identitystore.model.GetUserIdRequest.ReadOnly {
    override val identityStoreId: IdentityStoreId =
      zio.aws.identitystore.model.primitives
        .IdentityStoreId(impl.identityStoreId())
    override val alternateIdentifier
        : zio.aws.identitystore.model.AlternateIdentifier.ReadOnly =
      zio.aws.identitystore.model.AlternateIdentifier
        .wrap(impl.alternateIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.GetUserIdRequest
  ): zio.aws.identitystore.model.GetUserIdRequest.ReadOnly = new Wrapper(impl)
}
