package zio.aws.identitystore
import zio.aws.identitystore.model.ListGroupMembershipsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.identitystore.model.{
  DeleteUserRequest,
  DeleteGroupMembershipRequest,
  DescribeUserRequest,
  ListGroupMembershipsRequest,
  DescribeGroupMembershipRequest,
  ListUsersRequest,
  UpdateGroupRequest,
  CreateGroupMembershipRequest,
  DescribeGroupRequest,
  DeleteGroupRequest,
  ListGroupsRequest,
  IsMemberInGroupsRequest,
  CreateUserRequest,
  ListGroupMembershipsForMemberRequest,
  GetGroupIdRequest,
  GetGroupMembershipIdRequest,
  CreateGroupRequest,
  UpdateUserRequest,
  GetUserIdRequest
}
import zio.stream.ZStream
import software.amazon.awssdk.services.identitystore.IdentitystoreAsyncClient
object IdentitystoreMock extends Mock[Identitystore] {
  object ListUsers
      extends Stream[
        ListUsersRequest,
        AwsError,
        zio.aws.identitystore.model.User.ReadOnly
      ]
  object ListUsersPaginated
      extends Effect[
        ListUsersRequest,
        AwsError,
        zio.aws.identitystore.model.ListUsersResponse.ReadOnly
      ]
  object UpdateUser
      extends Effect[
        UpdateUserRequest,
        AwsError,
        zio.aws.identitystore.model.UpdateUserResponse.ReadOnly
      ]
  object CreateGroupMembership
      extends Effect[
        CreateGroupMembershipRequest,
        AwsError,
        zio.aws.identitystore.model.CreateGroupMembershipResponse.ReadOnly
      ]
  object GetGroupId
      extends Effect[
        GetGroupIdRequest,
        AwsError,
        zio.aws.identitystore.model.GetGroupIdResponse.ReadOnly
      ]
  object DeleteGroup
      extends Effect[
        DeleteGroupRequest,
        AwsError,
        zio.aws.identitystore.model.DeleteGroupResponse.ReadOnly
      ]
  object IsMemberInGroups
      extends Effect[
        IsMemberInGroupsRequest,
        AwsError,
        zio.aws.identitystore.model.IsMemberInGroupsResponse.ReadOnly
      ]
  object GetUserId
      extends Effect[
        GetUserIdRequest,
        AwsError,
        zio.aws.identitystore.model.GetUserIdResponse.ReadOnly
      ]
  object ListGroups
      extends Stream[
        ListGroupsRequest,
        AwsError,
        zio.aws.identitystore.model.Group.ReadOnly
      ]
  object ListGroupsPaginated
      extends Effect[
        ListGroupsRequest,
        AwsError,
        zio.aws.identitystore.model.ListGroupsResponse.ReadOnly
      ]
  object DeleteGroupMembership
      extends Effect[
        DeleteGroupMembershipRequest,
        AwsError,
        zio.aws.identitystore.model.DeleteGroupMembershipResponse.ReadOnly
      ]
  object CreateUser
      extends Effect[
        CreateUserRequest,
        AwsError,
        zio.aws.identitystore.model.CreateUserResponse.ReadOnly
      ]
  object DescribeGroup
      extends Effect[
        DescribeGroupRequest,
        AwsError,
        zio.aws.identitystore.model.DescribeGroupResponse.ReadOnly
      ]
  object CreateGroup
      extends Effect[
        CreateGroupRequest,
        AwsError,
        zio.aws.identitystore.model.CreateGroupResponse.ReadOnly
      ]
  object ListGroupMemberships
      extends Stream[
        ListGroupMembershipsRequest,
        AwsError,
        zio.aws.identitystore.model.GroupMembership.ReadOnly
      ]
  object ListGroupMembershipsPaginated
      extends Effect[ListGroupMembershipsRequest, AwsError, ReadOnly]
  object DescribeGroupMembership
      extends Effect[
        DescribeGroupMembershipRequest,
        AwsError,
        zio.aws.identitystore.model.DescribeGroupMembershipResponse.ReadOnly
      ]
  object DescribeUser
      extends Effect[
        DescribeUserRequest,
        AwsError,
        zio.aws.identitystore.model.DescribeUserResponse.ReadOnly
      ]
  object UpdateGroup
      extends Effect[
        UpdateGroupRequest,
        AwsError,
        zio.aws.identitystore.model.UpdateGroupResponse.ReadOnly
      ]
  object DeleteUser
      extends Effect[
        DeleteUserRequest,
        AwsError,
        zio.aws.identitystore.model.DeleteUserResponse.ReadOnly
      ]
  object ListGroupMembershipsForMember
      extends Stream[
        ListGroupMembershipsForMemberRequest,
        AwsError,
        zio.aws.identitystore.model.GroupMembership.ReadOnly
      ]
  object ListGroupMembershipsForMemberPaginated
      extends Effect[
        ListGroupMembershipsForMemberRequest,
        AwsError,
        zio.aws.identitystore.model.ListGroupMembershipsForMemberResponse.ReadOnly
      ]
  object GetGroupMembershipId
      extends Effect[
        GetGroupMembershipIdRequest,
        AwsError,
        zio.aws.identitystore.model.GetGroupMembershipIdResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Identitystore] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Identitystore] { rts =>
        zio.ZIO.succeed {
          new Identitystore {
            val api: IdentitystoreAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Identitystore = this
            def listUsers(request: ListUsersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.identitystore.model.User.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListUsers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listUsersPaginated(request: ListUsersRequest): IO[
              AwsError,
              zio.aws.identitystore.model.ListUsersResponse.ReadOnly
            ] = proxy(ListUsersPaginated, request)
            def updateUser(request: UpdateUserRequest): IO[
              AwsError,
              zio.aws.identitystore.model.UpdateUserResponse.ReadOnly
            ] = proxy(UpdateUser, request)
            def createGroupMembership(
                request: CreateGroupMembershipRequest
            ): IO[
              AwsError,
              zio.aws.identitystore.model.CreateGroupMembershipResponse.ReadOnly
            ] = proxy(CreateGroupMembership, request)
            def getGroupId(request: GetGroupIdRequest): IO[
              AwsError,
              zio.aws.identitystore.model.GetGroupIdResponse.ReadOnly
            ] = proxy(GetGroupId, request)
            def deleteGroup(request: DeleteGroupRequest): IO[
              AwsError,
              zio.aws.identitystore.model.DeleteGroupResponse.ReadOnly
            ] = proxy(DeleteGroup, request)
            def isMemberInGroups(request: IsMemberInGroupsRequest): IO[
              AwsError,
              zio.aws.identitystore.model.IsMemberInGroupsResponse.ReadOnly
            ] = proxy(IsMemberInGroups, request)
            def getUserId(request: GetUserIdRequest): IO[
              AwsError,
              zio.aws.identitystore.model.GetUserIdResponse.ReadOnly
            ] = proxy(GetUserId, request)
            def listGroups(request: ListGroupsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.identitystore.model.Group.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def listGroupsPaginated(request: ListGroupsRequest): IO[
              AwsError,
              zio.aws.identitystore.model.ListGroupsResponse.ReadOnly
            ] = proxy(ListGroupsPaginated, request)
            def deleteGroupMembership(
                request: DeleteGroupMembershipRequest
            ): IO[
              AwsError,
              zio.aws.identitystore.model.DeleteGroupMembershipResponse.ReadOnly
            ] = proxy(DeleteGroupMembership, request)
            def createUser(request: CreateUserRequest): IO[
              AwsError,
              zio.aws.identitystore.model.CreateUserResponse.ReadOnly
            ] = proxy(CreateUser, request)
            def describeGroup(request: DescribeGroupRequest): IO[
              AwsError,
              zio.aws.identitystore.model.DescribeGroupResponse.ReadOnly
            ] = proxy(DescribeGroup, request)
            def createGroup(request: CreateGroupRequest): IO[
              AwsError,
              zio.aws.identitystore.model.CreateGroupResponse.ReadOnly
            ] = proxy(CreateGroup, request)
            def listGroupMemberships(
                request: ListGroupMembershipsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.identitystore.model.GroupMembership.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListGroupMemberships, request)
                }
                .getOrThrowFiberFailure()
            }
            def listGroupMembershipsPaginated(
                request: ListGroupMembershipsRequest
            ): IO[AwsError, ReadOnly] =
              proxy(ListGroupMembershipsPaginated, request)
            def describeGroupMembership(
                request: DescribeGroupMembershipRequest
            ): IO[
              AwsError,
              zio.aws.identitystore.model.DescribeGroupMembershipResponse.ReadOnly
            ] = proxy(DescribeGroupMembership, request)
            def describeUser(request: DescribeUserRequest): IO[
              AwsError,
              zio.aws.identitystore.model.DescribeUserResponse.ReadOnly
            ] = proxy(DescribeUser, request)
            def updateGroup(request: UpdateGroupRequest): IO[
              AwsError,
              zio.aws.identitystore.model.UpdateGroupResponse.ReadOnly
            ] = proxy(UpdateGroup, request)
            def deleteUser(request: DeleteUserRequest): IO[
              AwsError,
              zio.aws.identitystore.model.DeleteUserResponse.ReadOnly
            ] = proxy(DeleteUser, request)
            def listGroupMembershipsForMember(
                request: ListGroupMembershipsForMemberRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.identitystore.model.GroupMembership.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListGroupMembershipsForMember, request)
                }
                .getOrThrowFiberFailure()
            }
            def listGroupMembershipsForMemberPaginated(
                request: ListGroupMembershipsForMemberRequest
            ): IO[
              AwsError,
              zio.aws.identitystore.model.ListGroupMembershipsForMemberResponse.ReadOnly
            ] = proxy(ListGroupMembershipsForMemberPaginated, request)
            def getGroupMembershipId(request: GetGroupMembershipIdRequest): IO[
              AwsError,
              zio.aws.identitystore.model.GetGroupMembershipIdResponse.ReadOnly
            ] = proxy(GetGroupMembershipId, request)
          }
        }
      }
    }
  }
}
