package zio.aws.identitystore.model
import software.amazon.awssdk.core.document.Document
import zio.ZIO
import zio.aws.identitystore.model.primitives.AttributePath
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UniqueAttribute(
    attributePath: AttributePath,
    attributeValue: zio.aws.identitystore.model.AttributeValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.UniqueAttribute = {
    import UniqueAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.UniqueAttribute
      .builder()
      .attributePath(AttributePath.unwrap(attributePath): java.lang.String)
      .attributeValue(attributeValue)
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.UniqueAttribute.ReadOnly =
    zio.aws.identitystore.model.UniqueAttribute.wrap(buildAwsValue())
}
object UniqueAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.UniqueAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.UniqueAttribute =
      zio.aws.identitystore.model.UniqueAttribute(attributePath, attributeValue)
    def attributePath: AttributePath
    def attributeValue: Document
    def getAttributePath: ZIO[Any, Nothing, AttributePath] =
      ZIO.succeed(attributePath)
    def getAttributeValue: ZIO[Any, Nothing, Document] =
      ZIO.succeed(attributeValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.UniqueAttribute
  ) extends zio.aws.identitystore.model.UniqueAttribute.ReadOnly {
    override val attributePath: AttributePath =
      zio.aws.identitystore.model.primitives.AttributePath(impl.attributePath())
    override val attributeValue: Document = impl.attributeValue()
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.UniqueAttribute
  ): zio.aws.identitystore.model.UniqueAttribute.ReadOnly = new Wrapper(impl)
}
