package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.ResourceId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MemberId(userId: Optional[ResourceId] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.MemberId = {
    import MemberId.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.MemberId
      .builder()
      .optionallyWith(
        userId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.userId)
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.MemberId.ReadOnly =
    zio.aws.identitystore.model.MemberId.wrap(buildAwsValue())
}
object MemberId {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.MemberId
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.MemberId =
      zio.aws.identitystore.model.MemberId(userId.map(value => value))
    def userId: Optional[ResourceId]
    def getUserId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("userId", userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.MemberId
  ) extends zio.aws.identitystore.model.MemberId.ReadOnly {
    override val userId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => zio.aws.identitystore.model.primitives.ResourceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.MemberId
  ): zio.aws.identitystore.model.MemberId.ReadOnly = new Wrapper(impl)
}
