package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.{ResourceId, IdentityStoreId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteGroupRequest(
    identityStoreId: IdentityStoreId,
    groupId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.DeleteGroupRequest = {
    import DeleteGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.DeleteGroupRequest
      .builder()
      .identityStoreId(
        IdentityStoreId.unwrap(identityStoreId): java.lang.String
      )
      .groupId(ResourceId.unwrap(groupId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.DeleteGroupRequest.ReadOnly =
    zio.aws.identitystore.model.DeleteGroupRequest.wrap(buildAwsValue())
}
object DeleteGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.DeleteGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.DeleteGroupRequest =
      zio.aws.identitystore.model.DeleteGroupRequest(identityStoreId, groupId)
    def identityStoreId: IdentityStoreId
    def groupId: ResourceId
    def getIdentityStoreId: ZIO[Any, Nothing, IdentityStoreId] =
      ZIO.succeed(identityStoreId)
    def getGroupId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(groupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.DeleteGroupRequest
  ) extends zio.aws.identitystore.model.DeleteGroupRequest.ReadOnly {
    override val identityStoreId: IdentityStoreId =
      zio.aws.identitystore.model.primitives
        .IdentityStoreId(impl.identityStoreId())
    override val groupId: ResourceId =
      zio.aws.identitystore.model.primitives.ResourceId(impl.groupId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.DeleteGroupRequest
  ): zio.aws.identitystore.model.DeleteGroupRequest.ReadOnly = new Wrapper(impl)
}
