package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.SensitiveStringType
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Name(
    formatted: Optional[SensitiveStringType] = Optional.Absent,
    familyName: Optional[SensitiveStringType] = Optional.Absent,
    givenName: Optional[SensitiveStringType] = Optional.Absent,
    middleName: Optional[SensitiveStringType] = Optional.Absent,
    honorificPrefix: Optional[SensitiveStringType] = Optional.Absent,
    honorificSuffix: Optional[SensitiveStringType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.Name = {
    import Name.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.Name
      .builder()
      .optionallyWith(
        formatted.map(value =>
          SensitiveStringType.unwrap(value): java.lang.String
        )
      )(_.formatted)
      .optionallyWith(
        familyName.map(value =>
          SensitiveStringType.unwrap(value): java.lang.String
        )
      )(_.familyName)
      .optionallyWith(
        givenName.map(value =>
          SensitiveStringType.unwrap(value): java.lang.String
        )
      )(_.givenName)
      .optionallyWith(
        middleName.map(value =>
          SensitiveStringType.unwrap(value): java.lang.String
        )
      )(_.middleName)
      .optionallyWith(
        honorificPrefix.map(value =>
          SensitiveStringType.unwrap(value): java.lang.String
        )
      )(_.honorificPrefix)
      .optionallyWith(
        honorificSuffix.map(value =>
          SensitiveStringType.unwrap(value): java.lang.String
        )
      )(_.honorificSuffix)
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.Name.ReadOnly =
    zio.aws.identitystore.model.Name.wrap(buildAwsValue())
}
object Name {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.Name
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.Name =
      zio.aws.identitystore.model.Name(
        formatted.map(value => value),
        familyName.map(value => value),
        givenName.map(value => value),
        middleName.map(value => value),
        honorificPrefix.map(value => value),
        honorificSuffix.map(value => value)
      )
    def formatted: Optional[SensitiveStringType]
    def familyName: Optional[SensitiveStringType]
    def givenName: Optional[SensitiveStringType]
    def middleName: Optional[SensitiveStringType]
    def honorificPrefix: Optional[SensitiveStringType]
    def honorificSuffix: Optional[SensitiveStringType]
    def getFormatted: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("formatted", formatted)
    def getFamilyName: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("familyName", familyName)
    def getGivenName: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("givenName", givenName)
    def getMiddleName: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("middleName", middleName)
    def getHonorificPrefix: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("honorificPrefix", honorificPrefix)
    def getHonorificSuffix: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("honorificSuffix", honorificSuffix)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.Name
  ) extends zio.aws.identitystore.model.Name.ReadOnly {
    override val formatted: Optional[SensitiveStringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.formatted())
        .map(value =>
          zio.aws.identitystore.model.primitives.SensitiveStringType(value)
        )
    override val familyName: Optional[SensitiveStringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.familyName())
        .map(value =>
          zio.aws.identitystore.model.primitives.SensitiveStringType(value)
        )
    override val givenName: Optional[SensitiveStringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.givenName())
        .map(value =>
          zio.aws.identitystore.model.primitives.SensitiveStringType(value)
        )
    override val middleName: Optional[SensitiveStringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.middleName())
        .map(value =>
          zio.aws.identitystore.model.primitives.SensitiveStringType(value)
        )
    override val honorificPrefix: Optional[SensitiveStringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.honorificPrefix())
        .map(value =>
          zio.aws.identitystore.model.primitives.SensitiveStringType(value)
        )
    override val honorificSuffix: Optional[SensitiveStringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.honorificSuffix())
        .map(value =>
          zio.aws.identitystore.model.primitives.SensitiveStringType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.Name
  ): zio.aws.identitystore.model.Name.ReadOnly = new Wrapper(impl)
}
