package zio.aws.identitystore.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.identitystore.model.primitives.{
  NextToken,
  MaxResults,
  IdentityStoreId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListGroupsRequest(
    identityStoreId: IdentityStoreId,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.identitystore.model.Filter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.ListGroupsRequest = {
    import ListGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.ListGroupsRequest
      .builder()
      .identityStoreId(
        IdentityStoreId.unwrap(identityStoreId): java.lang.String
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.ListGroupsRequest.ReadOnly =
    zio.aws.identitystore.model.ListGroupsRequest.wrap(buildAwsValue())
}
object ListGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.ListGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.ListGroupsRequest =
      zio.aws.identitystore.model.ListGroupsRequest(
        identityStoreId,
        maxResults.map(value => value),
        nextToken.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def identityStoreId: IdentityStoreId
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def filters: Optional[List[zio.aws.identitystore.model.Filter.ReadOnly]]
    def getIdentityStoreId: ZIO[Any, Nothing, IdentityStoreId] =
      ZIO.succeed(identityStoreId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.identitystore.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.ListGroupsRequest
  ) extends zio.aws.identitystore.model.ListGroupsRequest.ReadOnly {
    override val identityStoreId: IdentityStoreId =
      zio.aws.identitystore.model.primitives
        .IdentityStoreId(impl.identityStoreId())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.identitystore.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.identitystore.model.primitives.NextToken(value))
    override val filters
        : Optional[List[zio.aws.identitystore.model.Filter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.identitystore.model.Filter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.ListGroupsRequest
  ): zio.aws.identitystore.model.ListGroupsRequest.ReadOnly = new Wrapper(impl)
}
