package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.{ResourceId, IdentityStoreId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeUserRequest(
    identityStoreId: IdentityStoreId,
    userId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.DescribeUserRequest = {
    import DescribeUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.DescribeUserRequest
      .builder()
      .identityStoreId(
        IdentityStoreId.unwrap(identityStoreId): java.lang.String
      )
      .userId(ResourceId.unwrap(userId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.DescribeUserRequest.ReadOnly =
    zio.aws.identitystore.model.DescribeUserRequest.wrap(buildAwsValue())
}
object DescribeUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.DescribeUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.DescribeUserRequest =
      zio.aws.identitystore.model.DescribeUserRequest(identityStoreId, userId)
    def identityStoreId: IdentityStoreId
    def userId: ResourceId
    def getIdentityStoreId: ZIO[Any, Nothing, IdentityStoreId] =
      ZIO.succeed(identityStoreId)
    def getUserId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.DescribeUserRequest
  ) extends zio.aws.identitystore.model.DescribeUserRequest.ReadOnly {
    override val identityStoreId: IdentityStoreId =
      zio.aws.identitystore.model.primitives
        .IdentityStoreId(impl.identityStoreId())
    override val userId: ResourceId =
      zio.aws.identitystore.model.primitives.ResourceId(impl.userId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.DescribeUserRequest
  ): zio.aws.identitystore.model.DescribeUserRequest.ReadOnly = new Wrapper(
    impl
  )
}
