package zio.aws.identitystore.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.identitystore.model.primitives.{
  NextToken,
  MaxResults,
  ResourceId,
  IdentityStoreId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListGroupMembershipsRequest(
    identityStoreId: IdentityStoreId,
    groupId: ResourceId,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsRequest = {
    import ListGroupMembershipsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsRequest
      .builder()
      .identityStoreId(
        IdentityStoreId.unwrap(identityStoreId): java.lang.String
      )
      .groupId(ResourceId.unwrap(groupId): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.identitystore.model.ListGroupMembershipsRequest.ReadOnly =
    zio.aws.identitystore.model.ListGroupMembershipsRequest
      .wrap(buildAwsValue())
}
object ListGroupMembershipsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.ListGroupMembershipsRequest =
      zio.aws.identitystore.model.ListGroupMembershipsRequest(
        identityStoreId,
        groupId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def identityStoreId: IdentityStoreId
    def groupId: ResourceId
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getIdentityStoreId: ZIO[Any, Nothing, IdentityStoreId] =
      ZIO.succeed(identityStoreId)
    def getGroupId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(groupId)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsRequest
  ) extends zio.aws.identitystore.model.ListGroupMembershipsRequest.ReadOnly {
    override val identityStoreId: IdentityStoreId =
      zio.aws.identitystore.model.primitives
        .IdentityStoreId(impl.identityStoreId())
    override val groupId: ResourceId =
      zio.aws.identitystore.model.primitives.ResourceId(impl.groupId())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.identitystore.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.identitystore.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.ListGroupMembershipsRequest
  ): zio.aws.identitystore.model.ListGroupMembershipsRequest.ReadOnly =
    new Wrapper(impl)
}
