package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.IdentityStoreId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetGroupIdRequest(
    identityStoreId: IdentityStoreId,
    alternateIdentifier: zio.aws.identitystore.model.AlternateIdentifier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.GetGroupIdRequest = {
    import GetGroupIdRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.GetGroupIdRequest
      .builder()
      .identityStoreId(
        IdentityStoreId.unwrap(identityStoreId): java.lang.String
      )
      .alternateIdentifier(alternateIdentifier.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.GetGroupIdRequest.ReadOnly =
    zio.aws.identitystore.model.GetGroupIdRequest.wrap(buildAwsValue())
}
object GetGroupIdRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.GetGroupIdRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.GetGroupIdRequest =
      zio.aws.identitystore.model
        .GetGroupIdRequest(identityStoreId, alternateIdentifier.asEditable)
    def identityStoreId: IdentityStoreId
    def alternateIdentifier
        : zio.aws.identitystore.model.AlternateIdentifier.ReadOnly
    def getIdentityStoreId: ZIO[Any, Nothing, IdentityStoreId] =
      ZIO.succeed(identityStoreId)
    def getAlternateIdentifier: ZIO[
      Any,
      Nothing,
      zio.aws.identitystore.model.AlternateIdentifier.ReadOnly
    ] = ZIO.succeed(alternateIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.GetGroupIdRequest
  ) extends zio.aws.identitystore.model.GetGroupIdRequest.ReadOnly {
    override val identityStoreId: IdentityStoreId =
      zio.aws.identitystore.model.primitives
        .IdentityStoreId(impl.identityStoreId())
    override val alternateIdentifier
        : zio.aws.identitystore.model.AlternateIdentifier.ReadOnly =
      zio.aws.identitystore.model.AlternateIdentifier
        .wrap(impl.alternateIdentifier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.GetGroupIdRequest
  ): zio.aws.identitystore.model.GetGroupIdRequest.ReadOnly = new Wrapper(impl)
}
