package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.{
  SensitiveStringType,
  GroupDisplayName,
  IdentityStoreId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateGroupRequest(
    identityStoreId: IdentityStoreId,
    displayName: Optional[GroupDisplayName] = Optional.Absent,
    description: Optional[SensitiveStringType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.CreateGroupRequest = {
    import CreateGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.CreateGroupRequest
      .builder()
      .identityStoreId(
        IdentityStoreId.unwrap(identityStoreId): java.lang.String
      )
      .optionallyWith(
        displayName.map(value =>
          GroupDisplayName.unwrap(value): java.lang.String
        )
      )(_.displayName)
      .optionallyWith(
        description.map(value =>
          SensitiveStringType.unwrap(value): java.lang.String
        )
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.CreateGroupRequest.ReadOnly =
    zio.aws.identitystore.model.CreateGroupRequest.wrap(buildAwsValue())
}
object CreateGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.CreateGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.CreateGroupRequest =
      zio.aws.identitystore.model.CreateGroupRequest(
        identityStoreId,
        displayName.map(value => value),
        description.map(value => value)
      )
    def identityStoreId: IdentityStoreId
    def displayName: Optional[GroupDisplayName]
    def description: Optional[SensitiveStringType]
    def getIdentityStoreId: ZIO[Any, Nothing, IdentityStoreId] =
      ZIO.succeed(identityStoreId)
    def getDisplayName: ZIO[Any, AwsError, GroupDisplayName] =
      AwsError.unwrapOptionField("displayName", displayName)
    def getDescription: ZIO[Any, AwsError, SensitiveStringType] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.CreateGroupRequest
  ) extends zio.aws.identitystore.model.CreateGroupRequest.ReadOnly {
    override val identityStoreId: IdentityStoreId =
      zio.aws.identitystore.model.primitives
        .IdentityStoreId(impl.identityStoreId())
    override val displayName: Optional[GroupDisplayName] = zio.aws.core.internal
      .optionalFromNullable(impl.displayName())
      .map(value =>
        zio.aws.identitystore.model.primitives.GroupDisplayName(value)
      )
    override val description: Optional[SensitiveStringType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.identitystore.model.primitives.SensitiveStringType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.CreateGroupRequest
  ): zio.aws.identitystore.model.CreateGroupRequest.ReadOnly = new Wrapper(impl)
}
