package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.{ResourceId, IdentityStoreId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class IsMemberInGroupsRequest(
    identityStoreId: IdentityStoreId,
    memberId: zio.aws.identitystore.model.MemberId,
    groupIds: Iterable[ResourceId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.IsMemberInGroupsRequest = {
    import IsMemberInGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.IsMemberInGroupsRequest
      .builder()
      .identityStoreId(
        IdentityStoreId.unwrap(identityStoreId): java.lang.String
      )
      .memberId(memberId.buildAwsValue())
      .groupIds(groupIds.map { item =>
        ResourceId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.IsMemberInGroupsRequest.ReadOnly =
    zio.aws.identitystore.model.IsMemberInGroupsRequest.wrap(buildAwsValue())
}
object IsMemberInGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.IsMemberInGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.IsMemberInGroupsRequest =
      zio.aws.identitystore.model
        .IsMemberInGroupsRequest(identityStoreId, memberId.asEditable, groupIds)
    def identityStoreId: IdentityStoreId
    def memberId: zio.aws.identitystore.model.MemberId.ReadOnly
    def groupIds: List[ResourceId]
    def getIdentityStoreId: ZIO[Any, Nothing, IdentityStoreId] =
      ZIO.succeed(identityStoreId)
    def getMemberId
        : ZIO[Any, Nothing, zio.aws.identitystore.model.MemberId.ReadOnly] =
      ZIO.succeed(memberId)
    def getGroupIds: ZIO[Any, Nothing, List[ResourceId]] = ZIO.succeed(groupIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.IsMemberInGroupsRequest
  ) extends zio.aws.identitystore.model.IsMemberInGroupsRequest.ReadOnly {
    override val identityStoreId: IdentityStoreId =
      zio.aws.identitystore.model.primitives
        .IdentityStoreId(impl.identityStoreId())
    override val memberId: zio.aws.identitystore.model.MemberId.ReadOnly =
      zio.aws.identitystore.model.MemberId.wrap(impl.memberId())
    override val groupIds: List[ResourceId] = impl
      .groupIds()
      .asScala
      .map { item =>
        zio.aws.identitystore.model.primitives.ResourceId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.IsMemberInGroupsRequest
  ): zio.aws.identitystore.model.IsMemberInGroupsRequest.ReadOnly = new Wrapper(
    impl
  )
}
