package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.{ResourceId, IdentityStoreId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UpdateUserRequest(
    identityStoreId: IdentityStoreId,
    userId: ResourceId,
    operations: Iterable[zio.aws.identitystore.model.AttributeOperation]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.UpdateUserRequest = {
    import UpdateUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.UpdateUserRequest
      .builder()
      .identityStoreId(
        IdentityStoreId.unwrap(identityStoreId): java.lang.String
      )
      .userId(ResourceId.unwrap(userId): java.lang.String)
      .operations(operations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.UpdateUserRequest.ReadOnly =
    zio.aws.identitystore.model.UpdateUserRequest.wrap(buildAwsValue())
}
object UpdateUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.UpdateUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.UpdateUserRequest =
      zio.aws.identitystore.model.UpdateUserRequest(
        identityStoreId,
        userId,
        operations.map { item =>
          item.asEditable
        }
      )
    def identityStoreId: IdentityStoreId
    def userId: ResourceId
    def operations
        : List[zio.aws.identitystore.model.AttributeOperation.ReadOnly]
    def getIdentityStoreId: ZIO[Any, Nothing, IdentityStoreId] =
      ZIO.succeed(identityStoreId)
    def getUserId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(userId)
    def getOperations: ZIO[Any, Nothing, List[
      zio.aws.identitystore.model.AttributeOperation.ReadOnly
    ]] = ZIO.succeed(operations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.UpdateUserRequest
  ) extends zio.aws.identitystore.model.UpdateUserRequest.ReadOnly {
    override val identityStoreId: IdentityStoreId =
      zio.aws.identitystore.model.primitives
        .IdentityStoreId(impl.identityStoreId())
    override val userId: ResourceId =
      zio.aws.identitystore.model.primitives.ResourceId(impl.userId())
    override val operations
        : List[zio.aws.identitystore.model.AttributeOperation.ReadOnly] = impl
      .operations()
      .asScala
      .map { item =>
        zio.aws.identitystore.model.AttributeOperation.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.UpdateUserRequest
  ): zio.aws.identitystore.model.UpdateUserRequest.ReadOnly = new Wrapper(impl)
}
