package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.{ResourceId, IdentityStoreId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteUserRequest(
    identityStoreId: IdentityStoreId,
    userId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.DeleteUserRequest = {
    import DeleteUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.DeleteUserRequest
      .builder()
      .identityStoreId(
        IdentityStoreId.unwrap(identityStoreId): java.lang.String
      )
      .userId(ResourceId.unwrap(userId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.DeleteUserRequest.ReadOnly =
    zio.aws.identitystore.model.DeleteUserRequest.wrap(buildAwsValue())
}
object DeleteUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.DeleteUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.DeleteUserRequest =
      zio.aws.identitystore.model.DeleteUserRequest(identityStoreId, userId)
    def identityStoreId: IdentityStoreId
    def userId: ResourceId
    def getIdentityStoreId: ZIO[Any, Nothing, IdentityStoreId] =
      ZIO.succeed(identityStoreId)
    def getUserId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.DeleteUserRequest
  ) extends zio.aws.identitystore.model.DeleteUserRequest.ReadOnly {
    override val identityStoreId: IdentityStoreId =
      zio.aws.identitystore.model.primitives
        .IdentityStoreId(impl.identityStoreId())
    override val userId: ResourceId =
      zio.aws.identitystore.model.primitives.ResourceId(impl.userId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.DeleteUserRequest
  ): zio.aws.identitystore.model.DeleteUserRequest.ReadOnly = new Wrapper(impl)
}
