package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.{IdentityStoreId, ResourceId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateGroupResponse(
    groupId: ResourceId,
    identityStoreId: IdentityStoreId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.CreateGroupResponse = {
    import CreateGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.CreateGroupResponse
      .builder()
      .groupId(ResourceId.unwrap(groupId): java.lang.String)
      .identityStoreId(
        IdentityStoreId.unwrap(identityStoreId): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.CreateGroupResponse.ReadOnly =
    zio.aws.identitystore.model.CreateGroupResponse.wrap(buildAwsValue())
}
object CreateGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.CreateGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.CreateGroupResponse =
      zio.aws.identitystore.model.CreateGroupResponse(groupId, identityStoreId)
    def groupId: ResourceId
    def identityStoreId: IdentityStoreId
    def getGroupId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(groupId)
    def getIdentityStoreId: ZIO[Any, Nothing, IdentityStoreId] =
      ZIO.succeed(identityStoreId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.CreateGroupResponse
  ) extends zio.aws.identitystore.model.CreateGroupResponse.ReadOnly {
    override val groupId: ResourceId =
      zio.aws.identitystore.model.primitives.ResourceId(impl.groupId())
    override val identityStoreId: IdentityStoreId =
      zio.aws.identitystore.model.primitives
        .IdentityStoreId(impl.identityStoreId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.CreateGroupResponse
  ): zio.aws.identitystore.model.CreateGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
