package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.{
  SensitiveStringType,
  AttributePath
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Filter(
    attributePath: AttributePath,
    attributeValue: SensitiveStringType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.Filter
      .builder()
      .attributePath(AttributePath.unwrap(attributePath): java.lang.String)
      .attributeValue(
        SensitiveStringType.unwrap(attributeValue): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.Filter.ReadOnly =
    zio.aws.identitystore.model.Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.Filter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.Filter =
      zio.aws.identitystore.model.Filter(attributePath, attributeValue)
    def attributePath: AttributePath
    def attributeValue: SensitiveStringType
    def getAttributePath: ZIO[Any, Nothing, AttributePath] =
      ZIO.succeed(attributePath)
    def getAttributeValue: ZIO[Any, Nothing, SensitiveStringType] =
      ZIO.succeed(attributeValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.Filter
  ) extends zio.aws.identitystore.model.Filter.ReadOnly {
    override val attributePath: AttributePath =
      zio.aws.identitystore.model.primitives.AttributePath(impl.attributePath())
    override val attributeValue: SensitiveStringType =
      zio.aws.identitystore.model.primitives
        .SensitiveStringType(impl.attributeValue())
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.Filter
  ): zio.aws.identitystore.model.Filter.ReadOnly = new Wrapper(impl)
}
