package zio.aws.identitystore
import zio.mock.{Proxy, Mock}
import zio.aws.identitystore.model.ListGroupsResponse.ReadOnly
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.identitystore.model.{
  ListUsersRequest,
  ListGroupsRequest,
  DescribeUserRequest,
  DescribeGroupRequest
}
import zio.stream.ZStream
import software.amazon.awssdk.services.identitystore.IdentitystoreAsyncClient
object IdentitystoreMock extends Mock[Identitystore] {
  object DescribeGroup
      extends Effect[
        DescribeGroupRequest,
        AwsError,
        zio.aws.identitystore.model.DescribeGroupResponse.ReadOnly
      ]
  object DescribeUser
      extends Effect[
        DescribeUserRequest,
        AwsError,
        zio.aws.identitystore.model.DescribeUserResponse.ReadOnly
      ]
  object ListGroups
      extends Stream[
        ListGroupsRequest,
        AwsError,
        zio.aws.identitystore.model.Group.ReadOnly
      ]
  object ListGroupsPaginated
      extends Effect[ListGroupsRequest, AwsError, ReadOnly]
  object ListUsers
      extends Stream[
        ListUsersRequest,
        AwsError,
        zio.aws.identitystore.model.User.ReadOnly
      ]
  object ListUsersPaginated
      extends Effect[
        ListUsersRequest,
        AwsError,
        zio.aws.identitystore.model.ListUsersResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Identitystore] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Identitystore] { rts =>
        zio.ZIO.succeed {
          new Identitystore {
            val api: IdentitystoreAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Identitystore = this
            def describeGroup(request: DescribeGroupRequest): IO[
              AwsError,
              zio.aws.identitystore.model.DescribeGroupResponse.ReadOnly
            ] = proxy(DescribeGroup, request)
            def describeUser(request: DescribeUserRequest): IO[
              AwsError,
              zio.aws.identitystore.model.DescribeUserResponse.ReadOnly
            ] = proxy(DescribeUser, request)
            def listGroups(request: ListGroupsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.identitystore.model.Group.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def listGroupsPaginated(
                request: ListGroupsRequest
            ): IO[AwsError, ReadOnly] = proxy(ListGroupsPaginated, request)
            def listUsers(request: ListUsersRequest): ZStream[
              Any,
              AwsError,
              zio.aws.identitystore.model.User.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListUsers, request)
                }
                .getOrThrowFiberFailure()
            }
            def listUsersPaginated(request: ListUsersRequest): IO[
              AwsError,
              zio.aws.identitystore.model.ListUsersResponse.ReadOnly
            ] = proxy(ListUsersPaginated, request)
          }
        }
      }
    }
  }
}
