package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.{ResourceId, UserName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeUserResponse(userName: UserName, userId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.DescribeUserResponse = {
    import DescribeUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.DescribeUserResponse
      .builder()
      .userName(UserName.unwrap(userName): java.lang.String)
      .userId(ResourceId.unwrap(userId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.DescribeUserResponse.ReadOnly =
    zio.aws.identitystore.model.DescribeUserResponse.wrap(buildAwsValue())
}
object DescribeUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.DescribeUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.DescribeUserResponse =
      zio.aws.identitystore.model.DescribeUserResponse(userName, userId)
    def userName: UserName
    def userId: ResourceId
    def getUserName: ZIO[Any, Nothing, UserName] = ZIO.succeed(userName)
    def getUserId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.DescribeUserResponse
  ) extends zio.aws.identitystore.model.DescribeUserResponse.ReadOnly {
    override val userName: UserName =
      zio.aws.identitystore.model.primitives.UserName(impl.userName())
    override val userId: ResourceId =
      zio.aws.identitystore.model.primitives.ResourceId(impl.userId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.DescribeUserResponse
  ): zio.aws.identitystore.model.DescribeUserResponse.ReadOnly = new Wrapper(
    impl
  )
}
