package zio.aws.identitystore
import zio.aws.core.config.AwsConfig
import zio.aws.identitystore.model.ListGroupsResponse.ReadOnly
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.identitystore.model.{
  DescribeUserRequest,
  ListUsersRequest,
  ListUsersResponse,
  DescribeUserResponse,
  User,
  DescribeGroupRequest,
  ListGroupsRequest,
  Group,
  DescribeGroupResponse,
  ListGroupsResponse
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import zio.stream.ZStream
import software.amazon.awssdk.services.identitystore.{
  IdentitystoreAsyncClientBuilder,
  IdentitystoreAsyncClient
}
import scala.jdk.CollectionConverters._
trait Identitystore extends AspectSupport[Identitystore] {
  val api: IdentitystoreAsyncClient
  def describeGroup(
      request: zio.aws.identitystore.model.DescribeGroupRequest
  ): IO[AwsError, zio.aws.identitystore.model.DescribeGroupResponse.ReadOnly]
  def describeUser(
      request: zio.aws.identitystore.model.DescribeUserRequest
  ): IO[AwsError, zio.aws.identitystore.model.DescribeUserResponse.ReadOnly]
  def listGroups(
      request: zio.aws.identitystore.model.ListGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.identitystore.model.Group.ReadOnly]
  def listGroupsPaginated(
      request: zio.aws.identitystore.model.ListGroupsRequest
  ): IO[AwsError, ReadOnly]
  def listUsers(
      request: zio.aws.identitystore.model.ListUsersRequest
  ): ZStream[Any, AwsError, zio.aws.identitystore.model.User.ReadOnly]
  def listUsersPaginated(
      request: zio.aws.identitystore.model.ListUsersRequest
  ): IO[AwsError, zio.aws.identitystore.model.ListUsersResponse.ReadOnly]
}
object Identitystore {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Identitystore] = customized(
    identity
  )
  def customized(
      customization: IdentitystoreAsyncClientBuilder => IdentitystoreAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Identitystore] = managed(
    customization
  ).toLayer
  def managed(
      customization: IdentitystoreAsyncClientBuilder => IdentitystoreAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, Identitystore] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = IdentitystoreAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[IdentitystoreAsyncClient, IdentitystoreAsyncClientBuilder](
        builder
      )
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        IdentitystoreAsyncClient,
        IdentitystoreAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new IdentitystoreImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class IdentitystoreImpl[R](
      override val api: IdentitystoreAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Identitystore
      with AwsServiceBase[R] {
    override val serviceName: String = "Identitystore"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): IdentitystoreImpl[R1] = new IdentitystoreImpl(api, newAspect, r)
    def describeGroup(
        request: zio.aws.identitystore.model.DescribeGroupRequest
    ): IO[
      AwsError,
      zio.aws.identitystore.model.DescribeGroupResponse.ReadOnly
    ] = asyncRequestResponse[DescribeGroupRequest, DescribeGroupResponse](
      "describeGroup",
      api.describeGroup
    )(request.buildAwsValue())
      .map(zio.aws.identitystore.model.DescribeGroupResponse.wrap)
      .provideEnvironment(r)
    def describeUser(
        request: zio.aws.identitystore.model.DescribeUserRequest
    ): IO[AwsError, zio.aws.identitystore.model.DescribeUserResponse.ReadOnly] =
      asyncRequestResponse[DescribeUserRequest, DescribeUserResponse](
        "describeUser",
        api.describeUser
      )(request.buildAwsValue())
        .map(zio.aws.identitystore.model.DescribeUserResponse.wrap)
        .provideEnvironment(r)
    def listGroups(
        request: zio.aws.identitystore.model.ListGroupsRequest
    ): ZStream[Any, AwsError, zio.aws.identitystore.model.Group.ReadOnly] =
      asyncSimplePaginatedRequest[ListGroupsRequest, ListGroupsResponse, Group](
        "listGroups",
        api.listGroups,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.groups().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.identitystore.model.Group.wrap(item))
        .provideEnvironment(r)
    def listGroupsPaginated(
        request: zio.aws.identitystore.model.ListGroupsRequest
    ): IO[AwsError, ReadOnly] =
      asyncRequestResponse[ListGroupsRequest, ListGroupsResponse](
        "listGroups",
        api.listGroups
      )(request.buildAwsValue())
        .map(zio.aws.identitystore.model.ListGroupsResponse.wrap)
        .provideEnvironment(r)
    def listUsers(
        request: zio.aws.identitystore.model.ListUsersRequest
    ): ZStream[Any, AwsError, zio.aws.identitystore.model.User.ReadOnly] =
      asyncSimplePaginatedRequest[ListUsersRequest, ListUsersResponse, User](
        "listUsers",
        api.listUsers,
        (r, token) => r.toBuilder().nextToken(token).build(),
        r => scala.Option(r.nextToken()),
        r => zio.Chunk.fromIterable(r.users().asScala)
      )(request.buildAwsValue())
        .map(item => zio.aws.identitystore.model.User.wrap(item))
        .provideEnvironment(r)
    def listUsersPaginated(
        request: zio.aws.identitystore.model.ListUsersRequest
    ): IO[AwsError, zio.aws.identitystore.model.ListUsersResponse.ReadOnly] =
      asyncRequestResponse[ListUsersRequest, ListUsersResponse](
        "listUsers",
        api.listUsers
      )(request.buildAwsValue())
        .map(zio.aws.identitystore.model.ListUsersResponse.wrap)
        .provideEnvironment(r)
  }
  def describeGroup(
      request: zio.aws.identitystore.model.DescribeGroupRequest
  ): ZIO[
    zio.aws.identitystore.Identitystore,
    AwsError,
    zio.aws.identitystore.model.DescribeGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeGroup(request))
  def describeUser(
      request: zio.aws.identitystore.model.DescribeUserRequest
  ): ZIO[
    zio.aws.identitystore.Identitystore,
    AwsError,
    zio.aws.identitystore.model.DescribeUserResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeUser(request))
  def listGroups(
      request: zio.aws.identitystore.model.ListGroupsRequest
  ): ZStream[
    zio.aws.identitystore.Identitystore,
    AwsError,
    zio.aws.identitystore.model.Group.ReadOnly
  ] = ZStream.serviceWithStream(_.listGroups(request))
  def listGroupsPaginated(
      request: zio.aws.identitystore.model.ListGroupsRequest
  ): ZIO[zio.aws.identitystore.Identitystore, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.listGroupsPaginated(request))
  def listUsers(request: zio.aws.identitystore.model.ListUsersRequest): ZStream[
    zio.aws.identitystore.Identitystore,
    AwsError,
    zio.aws.identitystore.model.User.ReadOnly
  ] = ZStream.serviceWithStream(_.listUsers(request))
  def listUsersPaginated(
      request: zio.aws.identitystore.model.ListUsersRequest
  ): ZIO[
    zio.aws.identitystore.Identitystore,
    AwsError,
    zio.aws.identitystore.model.ListUsersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listUsersPaginated(request))
}
