package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.{GroupDisplayName, ResourceId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class Group(groupId: ResourceId, displayName: GroupDisplayName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.Group = {
    import Group.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.Group
      .builder()
      .groupId(ResourceId.unwrap(groupId): java.lang.String)
      .displayName(GroupDisplayName.unwrap(displayName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.Group.ReadOnly =
    zio.aws.identitystore.model.Group.wrap(buildAwsValue())
}
object Group {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.Group
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.Group =
      zio.aws.identitystore.model.Group(groupId, displayName)
    def groupId: ResourceId
    def displayName: GroupDisplayName
    def getGroupId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(groupId)
    def getDisplayName: ZIO[Any, Nothing, GroupDisplayName] =
      ZIO.succeed(displayName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.Group
  ) extends zio.aws.identitystore.model.Group.ReadOnly {
    override val groupId: ResourceId =
      zio.aws.identitystore.model.primitives.ResourceId(impl.groupId())
    override val displayName: GroupDisplayName =
      zio.aws.identitystore.model.primitives
        .GroupDisplayName(impl.displayName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.Group
  ): zio.aws.identitystore.model.Group.ReadOnly = new Wrapper(impl)
}
