package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.{ResourceId, UserName}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class User(userName: UserName, userId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.User = {
    import User.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.User
      .builder()
      .userName(UserName.unwrap(userName): java.lang.String)
      .userId(ResourceId.unwrap(userId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.User.ReadOnly =
    zio.aws.identitystore.model.User.wrap(buildAwsValue())
}
object User {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.User
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.User =
      zio.aws.identitystore.model.User(userName, userId)
    def userName: UserName
    def userId: ResourceId
    def getUserName: ZIO[Any, Nothing, UserName] = ZIO.succeed(userName)
    def getUserId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.User
  ) extends zio.aws.identitystore.model.User.ReadOnly {
    override val userName: UserName =
      zio.aws.identitystore.model.primitives.UserName(impl.userName())
    override val userId: ResourceId =
      zio.aws.identitystore.model.primitives.ResourceId(impl.userId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.User
  ): zio.aws.identitystore.model.User.ReadOnly = new Wrapper(impl)
}
