package zio.aws.identitystore.model
import zio.ZIO
import zio.aws.identitystore.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ListUsersResponse(
    users: Iterable[zio.aws.identitystore.model.User],
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.identitystore.model.ListUsersResponse = {
    import ListUsersResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.identitystore.model.ListUsersResponse
      .builder()
      .users(users.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.identitystore.model.ListUsersResponse.ReadOnly =
    zio.aws.identitystore.model.ListUsersResponse.wrap(buildAwsValue())
}
object ListUsersResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.identitystore.model.ListUsersResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.identitystore.model.ListUsersResponse =
      zio.aws.identitystore.model.ListUsersResponse(
        users.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def users: List[zio.aws.identitystore.model.User.ReadOnly]
    def nextToken: Option[NextToken]
    def getUsers
        : ZIO[Any, Nothing, List[zio.aws.identitystore.model.User.ReadOnly]] =
      ZIO.succeed(users)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.identitystore.model.ListUsersResponse
  ) extends zio.aws.identitystore.model.ListUsersResponse.ReadOnly {
    override val users: List[zio.aws.identitystore.model.User.ReadOnly] = impl
      .users()
      .asScala
      .map { item =>
        zio.aws.identitystore.model.User.wrap(item)
      }
      .toList
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.identitystore.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.identitystore.model.ListUsersResponse
  ): zio.aws.identitystore.model.ListUsersResponse.ReadOnly = new Wrapper(impl)
}
