package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.honeycode.model.primitives.{
  ClientRequestToken,
  RowId,
  VariableName,
  ResourceId
}
import scala.jdk.CollectionConverters.*
final case class InvokeScreenAutomationRequest(
    workbookId: ResourceId,
    appId: ResourceId,
    screenId: ResourceId,
    screenAutomationId: ResourceId,
    variables: Optional[
      Map[VariableName, zio.aws.honeycode.model.VariableValue]
    ] = Optional.Absent,
    rowId: Optional[RowId] = Optional.Absent,
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.InvokeScreenAutomationRequest = {
    import InvokeScreenAutomationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.InvokeScreenAutomationRequest
      .builder()
      .workbookId(ResourceId.unwrap(workbookId): java.lang.String)
      .appId(ResourceId.unwrap(appId): java.lang.String)
      .screenId(ResourceId.unwrap(screenId): java.lang.String)
      .screenAutomationId(
        ResourceId.unwrap(screenAutomationId): java.lang.String
      )
      .optionallyWith(
        variables.map(value =>
          value
            .map({ case (key, value) =>
              (VariableName.unwrap(key): java.lang.String) -> value
                .buildAwsValue()
            })
            .asJava
        )
      )(_.variables)
      .optionallyWith(
        rowId.map(value => RowId.unwrap(value): java.lang.String)
      )(_.rowId)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly
      : zio.aws.honeycode.model.InvokeScreenAutomationRequest.ReadOnly =
    zio.aws.honeycode.model.InvokeScreenAutomationRequest.wrap(buildAwsValue())
}
object InvokeScreenAutomationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.InvokeScreenAutomationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.InvokeScreenAutomationRequest =
      zio.aws.honeycode.model.InvokeScreenAutomationRequest(
        workbookId,
        appId,
        screenId,
        screenAutomationId,
        variables.map(value =>
          value.map({ case (key, value) =>
            key -> value.asEditable
          })
        ),
        rowId.map(value => value),
        clientRequestToken.map(value => value)
      )
    def workbookId: ResourceId
    def appId: ResourceId
    def screenId: ResourceId
    def screenAutomationId: ResourceId
    def variables: Optional[
      Map[VariableName, zio.aws.honeycode.model.VariableValue.ReadOnly]
    ]
    def rowId: Optional[RowId]
    def clientRequestToken: Optional[ClientRequestToken]
    def getWorkbookId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(workbookId)
    def getAppId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(appId)
    def getScreenId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(screenId)
    def getScreenAutomationId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(screenAutomationId)
    def getVariables: ZIO[Any, AwsError, Map[
      VariableName,
      zio.aws.honeycode.model.VariableValue.ReadOnly
    ]] = AwsError.unwrapOptionField("variables", variables)
    def getRowId: ZIO[Any, AwsError, RowId] =
      AwsError.unwrapOptionField("rowId", rowId)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.InvokeScreenAutomationRequest
  ) extends zio.aws.honeycode.model.InvokeScreenAutomationRequest.ReadOnly {
    override val workbookId: ResourceId =
      zio.aws.honeycode.model.primitives.ResourceId(impl.workbookId())
    override val appId: ResourceId =
      zio.aws.honeycode.model.primitives.ResourceId(impl.appId())
    override val screenId: ResourceId =
      zio.aws.honeycode.model.primitives.ResourceId(impl.screenId())
    override val screenAutomationId: ResourceId =
      zio.aws.honeycode.model.primitives.ResourceId(impl.screenAutomationId())
    override val variables: Optional[
      Map[VariableName, zio.aws.honeycode.model.VariableValue.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.variables())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.honeycode.model.primitives.VariableName(
              key
            ) -> zio.aws.honeycode.model.VariableValue.wrap(value)
          })
          .toMap
      )
    override val rowId: Optional[RowId] = zio.aws.core.internal
      .optionalFromNullable(impl.rowId())
      .map(value => zio.aws.honeycode.model.primitives.RowId(value))
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.honeycode.model.primitives.ClientRequestToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.InvokeScreenAutomationRequest
  ): zio.aws.honeycode.model.InvokeScreenAutomationRequest.ReadOnly =
    new Wrapper(impl)
}
