package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.honeycode.model.primitives.{ClientRequestToken, ResourceId}
import scala.jdk.CollectionConverters.*
final case class BatchCreateTableRowsRequest(
    workbookId: ResourceId,
    tableId: ResourceId,
    rowsToCreate: Iterable[zio.aws.honeycode.model.CreateRowData],
    clientRequestToken: Optional[ClientRequestToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.BatchCreateTableRowsRequest = {
    import BatchCreateTableRowsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.BatchCreateTableRowsRequest
      .builder()
      .workbookId(ResourceId.unwrap(workbookId): java.lang.String)
      .tableId(ResourceId.unwrap(tableId): java.lang.String)
      .rowsToCreate(rowsToCreate.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        clientRequestToken.map(value =>
          ClientRequestToken.unwrap(value): java.lang.String
        )
      )(_.clientRequestToken)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.BatchCreateTableRowsRequest.ReadOnly =
    zio.aws.honeycode.model.BatchCreateTableRowsRequest.wrap(buildAwsValue())
}
object BatchCreateTableRowsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.BatchCreateTableRowsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.BatchCreateTableRowsRequest =
      zio.aws.honeycode.model.BatchCreateTableRowsRequest(
        workbookId,
        tableId,
        rowsToCreate.map { item =>
          item.asEditable
        },
        clientRequestToken.map(value => value)
      )
    def workbookId: ResourceId
    def tableId: ResourceId
    def rowsToCreate: List[zio.aws.honeycode.model.CreateRowData.ReadOnly]
    def clientRequestToken: Optional[ClientRequestToken]
    def getWorkbookId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(workbookId)
    def getTableId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(tableId)
    def getRowsToCreate: ZIO[Any, Nothing, List[
      zio.aws.honeycode.model.CreateRowData.ReadOnly
    ]] = ZIO.succeed(rowsToCreate)
    def getClientRequestToken: ZIO[Any, AwsError, ClientRequestToken] =
      AwsError.unwrapOptionField("clientRequestToken", clientRequestToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.BatchCreateTableRowsRequest
  ) extends zio.aws.honeycode.model.BatchCreateTableRowsRequest.ReadOnly {
    override val workbookId: ResourceId =
      zio.aws.honeycode.model.primitives.ResourceId(impl.workbookId())
    override val tableId: ResourceId =
      zio.aws.honeycode.model.primitives.ResourceId(impl.tableId())
    override val rowsToCreate
        : List[zio.aws.honeycode.model.CreateRowData.ReadOnly] = impl
      .rowsToCreate()
      .asScala
      .map { item =>
        zio.aws.honeycode.model.CreateRowData.wrap(item)
      }
      .toList
    override val clientRequestToken: Optional[ClientRequestToken] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientRequestToken())
        .map(value =>
          zio.aws.honeycode.model.primitives.ClientRequestToken(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.BatchCreateTableRowsRequest
  ): zio.aws.honeycode.model.BatchCreateTableRowsRequest.ReadOnly = new Wrapper(
    impl
  )
}
