package zio.aws.honeycode.model
import zio.aws.honeycode.model.primitives.{
  PaginationToken,
  MaxResults,
  ResourceId
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class QueryTableRowsRequest(
    workbookId: ResourceId,
    tableId: ResourceId,
    filterFormula: zio.aws.honeycode.model.Filter,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.QueryTableRowsRequest = {
    import QueryTableRowsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.QueryTableRowsRequest
      .builder()
      .workbookId(ResourceId.unwrap(workbookId): java.lang.String)
      .tableId(ResourceId.unwrap(tableId): java.lang.String)
      .filterFormula(filterFormula.buildAwsValue())
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.QueryTableRowsRequest.ReadOnly =
    zio.aws.honeycode.model.QueryTableRowsRequest.wrap(buildAwsValue())
}
object QueryTableRowsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.QueryTableRowsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.QueryTableRowsRequest =
      zio.aws.honeycode.model.QueryTableRowsRequest(
        workbookId,
        tableId,
        filterFormula.asEditable,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def workbookId: ResourceId
    def tableId: ResourceId
    def filterFormula: zio.aws.honeycode.model.Filter.ReadOnly
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[PaginationToken]
    def getWorkbookId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(workbookId)
    def getTableId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(tableId)
    def getFilterFormula
        : ZIO[Any, Nothing, zio.aws.honeycode.model.Filter.ReadOnly] =
      ZIO.succeed(filterFormula)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.QueryTableRowsRequest
  ) extends zio.aws.honeycode.model.QueryTableRowsRequest.ReadOnly {
    override val workbookId: ResourceId =
      zio.aws.honeycode.model.primitives.ResourceId(impl.workbookId())
    override val tableId: ResourceId =
      zio.aws.honeycode.model.primitives.ResourceId(impl.tableId())
    override val filterFormula: zio.aws.honeycode.model.Filter.ReadOnly =
      zio.aws.honeycode.model.Filter.wrap(impl.filterFormula())
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.honeycode.model.primitives.MaxResults(value))
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.honeycode.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.QueryTableRowsRequest
  ): zio.aws.honeycode.model.QueryTableRowsRequest.ReadOnly = new Wrapper(impl)
}
