package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import java.time.Instant
import zio.aws.honeycode.model.primitives.TimestampInMillis
import scala.jdk.CollectionConverters.*
final case class TableDataImportJobMetadata(
    submitter: zio.aws.honeycode.model.ImportJobSubmitter,
    submitTime: TimestampInMillis,
    importOptions: zio.aws.honeycode.model.ImportOptions,
    dataSource: zio.aws.honeycode.model.ImportDataSource
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.TableDataImportJobMetadata = {
    import TableDataImportJobMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.TableDataImportJobMetadata
      .builder()
      .submitter(submitter.buildAwsValue())
      .submitTime(TimestampInMillis.unwrap(submitTime): Instant)
      .importOptions(importOptions.buildAwsValue())
      .dataSource(dataSource.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.TableDataImportJobMetadata.ReadOnly =
    zio.aws.honeycode.model.TableDataImportJobMetadata.wrap(buildAwsValue())
}
object TableDataImportJobMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.TableDataImportJobMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.TableDataImportJobMetadata =
      zio.aws.honeycode.model.TableDataImportJobMetadata(
        submitter.asEditable,
        submitTime,
        importOptions.asEditable,
        dataSource.asEditable
      )
    def submitter: zio.aws.honeycode.model.ImportJobSubmitter.ReadOnly
    def submitTime: TimestampInMillis
    def importOptions: zio.aws.honeycode.model.ImportOptions.ReadOnly
    def dataSource: zio.aws.honeycode.model.ImportDataSource.ReadOnly
    def getSubmitter: ZIO[
      Any,
      Nothing,
      zio.aws.honeycode.model.ImportJobSubmitter.ReadOnly
    ] = ZIO.succeed(submitter)
    def getSubmitTime: ZIO[Any, Nothing, TimestampInMillis] =
      ZIO.succeed(submitTime)
    def getImportOptions
        : ZIO[Any, Nothing, zio.aws.honeycode.model.ImportOptions.ReadOnly] =
      ZIO.succeed(importOptions)
    def getDataSource
        : ZIO[Any, Nothing, zio.aws.honeycode.model.ImportDataSource.ReadOnly] =
      ZIO.succeed(dataSource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.TableDataImportJobMetadata
  ) extends zio.aws.honeycode.model.TableDataImportJobMetadata.ReadOnly {
    override val submitter
        : zio.aws.honeycode.model.ImportJobSubmitter.ReadOnly =
      zio.aws.honeycode.model.ImportJobSubmitter.wrap(impl.submitter())
    override val submitTime: TimestampInMillis =
      zio.aws.honeycode.model.primitives.TimestampInMillis(impl.submitTime())
    override val importOptions: zio.aws.honeycode.model.ImportOptions.ReadOnly =
      zio.aws.honeycode.model.ImportOptions.wrap(impl.importOptions())
    override val dataSource: zio.aws.honeycode.model.ImportDataSource.ReadOnly =
      zio.aws.honeycode.model.ImportDataSource.wrap(impl.dataSource())
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.TableDataImportJobMetadata
  ): zio.aws.honeycode.model.TableDataImportJobMetadata.ReadOnly = new Wrapper(
    impl
  )
}
