package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.honeycode.model.primitives.{JobId, ResourceId}
import scala.jdk.CollectionConverters.*
final case class DescribeTableDataImportJobRequest(
    workbookId: ResourceId,
    tableId: ResourceId,
    jobId: JobId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.DescribeTableDataImportJobRequest = {
    import DescribeTableDataImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.DescribeTableDataImportJobRequest
      .builder()
      .workbookId(ResourceId.unwrap(workbookId): java.lang.String)
      .tableId(ResourceId.unwrap(tableId): java.lang.String)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.honeycode.model.DescribeTableDataImportJobRequest.ReadOnly =
    zio.aws.honeycode.model.DescribeTableDataImportJobRequest
      .wrap(buildAwsValue())
}
object DescribeTableDataImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.DescribeTableDataImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.DescribeTableDataImportJobRequest =
      zio.aws.honeycode.model
        .DescribeTableDataImportJobRequest(workbookId, tableId, jobId)
    def workbookId: ResourceId
    def tableId: ResourceId
    def jobId: JobId
    def getWorkbookId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(workbookId)
    def getTableId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(tableId)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.DescribeTableDataImportJobRequest
  ) extends zio.aws.honeycode.model.DescribeTableDataImportJobRequest.ReadOnly {
    override val workbookId: ResourceId =
      zio.aws.honeycode.model.primitives.ResourceId(impl.workbookId())
    override val tableId: ResourceId =
      zio.aws.honeycode.model.primitives.ResourceId(impl.tableId())
    override val jobId: JobId =
      zio.aws.honeycode.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.DescribeTableDataImportJobRequest
  ): zio.aws.honeycode.model.DescribeTableDataImportJobRequest.ReadOnly =
    new Wrapper(impl)
}
