package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.honeycode.model.primitives.{ResourceId, BatchItemId}
import scala.jdk.CollectionConverters.*
final case class CreateRowData(
    batchItemId: BatchItemId,
    cellsToCreate: Map[ResourceId, zio.aws.honeycode.model.CellInput]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.CreateRowData = {
    import CreateRowData.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.CreateRowData
      .builder()
      .batchItemId(BatchItemId.unwrap(batchItemId): java.lang.String)
      .cellsToCreate(
        cellsToCreate
          .map({ case (key, value) =>
            (ResourceId.unwrap(key): java.lang.String) -> value.buildAwsValue()
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.CreateRowData.ReadOnly =
    zio.aws.honeycode.model.CreateRowData.wrap(buildAwsValue())
}
object CreateRowData {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.CreateRowData
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.CreateRowData =
      zio.aws.honeycode.model.CreateRowData(
        batchItemId,
        cellsToCreate.map({ case (key, value) =>
          key -> value.asEditable
        })
      )
    def batchItemId: BatchItemId
    def cellsToCreate
        : Map[ResourceId, zio.aws.honeycode.model.CellInput.ReadOnly]
    def getBatchItemId: ZIO[Any, Nothing, BatchItemId] =
      ZIO.succeed(batchItemId)
    def getCellsToCreate: ZIO[Any, Nothing, Map[
      ResourceId,
      zio.aws.honeycode.model.CellInput.ReadOnly
    ]] = ZIO.succeed(cellsToCreate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.CreateRowData
  ) extends zio.aws.honeycode.model.CreateRowData.ReadOnly {
    override val batchItemId: BatchItemId =
      zio.aws.honeycode.model.primitives.BatchItemId(impl.batchItemId())
    override val cellsToCreate
        : Map[ResourceId, zio.aws.honeycode.model.CellInput.ReadOnly] = impl
      .cellsToCreate()
      .asScala
      .map({ case (key, value) =>
        zio.aws.honeycode.model.primitives
          .ResourceId(key) -> zio.aws.honeycode.model.CellInput.wrap(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.CreateRowData
  ): zio.aws.honeycode.model.CreateRowData.ReadOnly = new Wrapper(impl)
}
