package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.honeycode.model.primitives.{PaginationToken, ResourceId}
import scala.jdk.CollectionConverters.*
final case class ListTableColumnsRequest(
    workbookId: ResourceId,
    tableId: ResourceId,
    nextToken: Optional[PaginationToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.ListTableColumnsRequest = {
    import ListTableColumnsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.ListTableColumnsRequest
      .builder()
      .workbookId(ResourceId.unwrap(workbookId): java.lang.String)
      .tableId(ResourceId.unwrap(tableId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.ListTableColumnsRequest.ReadOnly =
    zio.aws.honeycode.model.ListTableColumnsRequest.wrap(buildAwsValue())
}
object ListTableColumnsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.ListTableColumnsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.ListTableColumnsRequest =
      zio.aws.honeycode.model.ListTableColumnsRequest(
        workbookId,
        tableId,
        nextToken.map(value => value)
      )
    def workbookId: ResourceId
    def tableId: ResourceId
    def nextToken: Optional[PaginationToken]
    def getWorkbookId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(workbookId)
    def getTableId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(tableId)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.ListTableColumnsRequest
  ) extends zio.aws.honeycode.model.ListTableColumnsRequest.ReadOnly {
    override val workbookId: ResourceId =
      zio.aws.honeycode.model.primitives.ResourceId(impl.workbookId())
    override val tableId: ResourceId =
      zio.aws.honeycode.model.primitives.ResourceId(impl.tableId())
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.honeycode.model.primitives.PaginationToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.ListTableColumnsRequest
  ): zio.aws.honeycode.model.ListTableColumnsRequest.ReadOnly = new Wrapper(
    impl
  )
}
