package zio.aws.honeycode.model
import scala.jdk.CollectionConverters.*
sealed trait ImportSourceDataFormat {
  def unwrap
      : software.amazon.awssdk.services.honeycode.model.ImportSourceDataFormat
}
object ImportSourceDataFormat {
  def wrap(
      value: software.amazon.awssdk.services.honeycode.model.ImportSourceDataFormat
  ): zio.aws.honeycode.model.ImportSourceDataFormat = value match {
    case software.amazon.awssdk.services.honeycode.model.ImportSourceDataFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.honeycode.model.ImportSourceDataFormat.DELIMITED_TEXT =>
      val r = DELIMITED_TEXT
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.honeycode.model.ImportSourceDataFormat {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.ImportSourceDataFormat =
      software.amazon.awssdk.services.honeycode.model.ImportSourceDataFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object DELIMITED_TEXT
      extends zio.aws.honeycode.model.ImportSourceDataFormat {
    override def unwrap
        : software.amazon.awssdk.services.honeycode.model.ImportSourceDataFormat =
      software.amazon.awssdk.services.honeycode.model.ImportSourceDataFormat.DELIMITED_TEXT
  }
}
