package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.honeycode.model.primitives.{BatchErrorMessage, BatchItemId}
import scala.jdk.CollectionConverters.*
final case class FailedBatchItem(
    id: BatchItemId,
    errorMessage: BatchErrorMessage
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.FailedBatchItem = {
    import FailedBatchItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.FailedBatchItem
      .builder()
      .id(BatchItemId.unwrap(id): java.lang.String)
      .errorMessage(BatchErrorMessage.unwrap(errorMessage): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.FailedBatchItem.ReadOnly =
    zio.aws.honeycode.model.FailedBatchItem.wrap(buildAwsValue())
}
object FailedBatchItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.FailedBatchItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.FailedBatchItem =
      zio.aws.honeycode.model.FailedBatchItem(id, errorMessage)
    def id: BatchItemId
    def errorMessage: BatchErrorMessage
    def getId: ZIO[Any, Nothing, BatchItemId] = ZIO.succeed(id)
    def getErrorMessage: ZIO[Any, Nothing, BatchErrorMessage] =
      ZIO.succeed(errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.FailedBatchItem
  ) extends zio.aws.honeycode.model.FailedBatchItem.ReadOnly {
    override val id: BatchItemId =
      zio.aws.honeycode.model.primitives.BatchItemId(impl.id())
    override val errorMessage: BatchErrorMessage =
      zio.aws.honeycode.model.primitives.BatchErrorMessage(impl.errorMessage())
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.FailedBatchItem
  ): zio.aws.honeycode.model.FailedBatchItem.ReadOnly = new Wrapper(impl)
}
