package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ImportDataSource(
    dataSourceConfig: zio.aws.honeycode.model.ImportDataSourceConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.ImportDataSource = {
    import ImportDataSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.ImportDataSource
      .builder()
      .dataSourceConfig(dataSourceConfig.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.ImportDataSource.ReadOnly =
    zio.aws.honeycode.model.ImportDataSource.wrap(buildAwsValue())
}
object ImportDataSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.ImportDataSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.ImportDataSource =
      zio.aws.honeycode.model.ImportDataSource(dataSourceConfig.asEditable)
    def dataSourceConfig
        : zio.aws.honeycode.model.ImportDataSourceConfig.ReadOnly
    def getDataSourceConfig: ZIO[
      Any,
      Nothing,
      zio.aws.honeycode.model.ImportDataSourceConfig.ReadOnly
    ] = ZIO.succeed(dataSourceConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.ImportDataSource
  ) extends zio.aws.honeycode.model.ImportDataSource.ReadOnly {
    override val dataSourceConfig
        : zio.aws.honeycode.model.ImportDataSourceConfig.ReadOnly =
      zio.aws.honeycode.model.ImportDataSourceConfig
        .wrap(impl.dataSourceConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.ImportDataSource
  ): zio.aws.honeycode.model.ImportDataSource.ReadOnly = new Wrapper(impl)
}
