package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.honeycode.model.primitives.WorkbookCursor
import scala.jdk.CollectionConverters.*
final case class BatchUpdateTableRowsResponse(
    workbookCursor: WorkbookCursor,
    failedBatchItems: Optional[
      Iterable[zio.aws.honeycode.model.FailedBatchItem]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.BatchUpdateTableRowsResponse = {
    import BatchUpdateTableRowsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.BatchUpdateTableRowsResponse
      .builder()
      .workbookCursor(WorkbookCursor.unwrap(workbookCursor): java.lang.Long)
      .optionallyWith(
        failedBatchItems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.failedBatchItems)
      .build()
  }
  def asReadOnly
      : zio.aws.honeycode.model.BatchUpdateTableRowsResponse.ReadOnly =
    zio.aws.honeycode.model.BatchUpdateTableRowsResponse.wrap(buildAwsValue())
}
object BatchUpdateTableRowsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.BatchUpdateTableRowsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.BatchUpdateTableRowsResponse =
      zio.aws.honeycode.model.BatchUpdateTableRowsResponse(
        workbookCursor,
        failedBatchItems.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def workbookCursor: WorkbookCursor
    def failedBatchItems
        : Optional[List[zio.aws.honeycode.model.FailedBatchItem.ReadOnly]]
    def getWorkbookCursor: ZIO[Any, Nothing, WorkbookCursor] =
      ZIO.succeed(workbookCursor)
    def getFailedBatchItems: ZIO[Any, AwsError, List[
      zio.aws.honeycode.model.FailedBatchItem.ReadOnly
    ]] = AwsError.unwrapOptionField("failedBatchItems", failedBatchItems)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.BatchUpdateTableRowsResponse
  ) extends zio.aws.honeycode.model.BatchUpdateTableRowsResponse.ReadOnly {
    override val workbookCursor: WorkbookCursor =
      zio.aws.honeycode.model.primitives.WorkbookCursor(impl.workbookCursor())
    override val failedBatchItems
        : Optional[List[zio.aws.honeycode.model.FailedBatchItem.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failedBatchItems())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.honeycode.model.FailedBatchItem.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.BatchUpdateTableRowsResponse
  ): zio.aws.honeycode.model.BatchUpdateTableRowsResponse.ReadOnly =
    new Wrapper(impl)
}
