package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.honeycode.model.primitives.{WorkbookCursor, PaginationToken}
import scala.jdk.CollectionConverters.*
final case class ListTablesResponse(
    tables: Iterable[zio.aws.honeycode.model.Table],
    nextToken: Optional[PaginationToken] = Optional.Absent,
    workbookCursor: Optional[WorkbookCursor] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.ListTablesResponse = {
    import ListTablesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.ListTablesResponse
      .builder()
      .tables(tables.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => PaginationToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        workbookCursor.map(value =>
          WorkbookCursor.unwrap(value): java.lang.Long
        )
      )(_.workbookCursor)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.ListTablesResponse.ReadOnly =
    zio.aws.honeycode.model.ListTablesResponse.wrap(buildAwsValue())
}
object ListTablesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.ListTablesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.ListTablesResponse =
      zio.aws.honeycode.model.ListTablesResponse(
        tables.map { item =>
          item.asEditable
        },
        nextToken.map(value => value),
        workbookCursor.map(value => value)
      )
    def tables: List[zio.aws.honeycode.model.Table.ReadOnly]
    def nextToken: Optional[PaginationToken]
    def workbookCursor: Optional[WorkbookCursor]
    def getTables
        : ZIO[Any, Nothing, List[zio.aws.honeycode.model.Table.ReadOnly]] =
      ZIO.succeed(tables)
    def getNextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getWorkbookCursor: ZIO[Any, AwsError, WorkbookCursor] =
      AwsError.unwrapOptionField("workbookCursor", workbookCursor)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.ListTablesResponse
  ) extends zio.aws.honeycode.model.ListTablesResponse.ReadOnly {
    override val tables: List[zio.aws.honeycode.model.Table.ReadOnly] = impl
      .tables()
      .asScala
      .map { item =>
        zio.aws.honeycode.model.Table.wrap(item)
      }
      .toList
    override val nextToken: Optional[PaginationToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.honeycode.model.primitives.PaginationToken(value))
    override val workbookCursor: Optional[WorkbookCursor] =
      zio.aws.core.internal
        .optionalFromNullable(impl.workbookCursor())
        .map(value => zio.aws.honeycode.model.primitives.WorkbookCursor(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.ListTablesResponse
  ): zio.aws.honeycode.model.ListTablesResponse.ReadOnly = new Wrapper(impl)
}
