package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.honeycode.model.primitives.{TableColumnName, ResourceId}
import scala.jdk.CollectionConverters.*
final case class TableColumn(
    tableColumnId: Optional[ResourceId] = Optional.Absent,
    tableColumnName: Optional[TableColumnName] = Optional.Absent,
    format: Optional[zio.aws.honeycode.model.Format] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.TableColumn = {
    import TableColumn.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.TableColumn
      .builder()
      .optionallyWith(
        tableColumnId.map(value => ResourceId.unwrap(value): java.lang.String)
      )(_.tableColumnId)
      .optionallyWith(
        tableColumnName.map(value =>
          TableColumnName.unwrap(value): java.lang.String
        )
      )(_.tableColumnName)
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.TableColumn.ReadOnly =
    zio.aws.honeycode.model.TableColumn.wrap(buildAwsValue())
}
object TableColumn {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.TableColumn
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.TableColumn =
      zio.aws.honeycode.model.TableColumn(
        tableColumnId.map(value => value),
        tableColumnName.map(value => value),
        format.map(value => value)
      )
    def tableColumnId: Optional[ResourceId]
    def tableColumnName: Optional[TableColumnName]
    def format: Optional[zio.aws.honeycode.model.Format]
    def getTableColumnId: ZIO[Any, AwsError, ResourceId] =
      AwsError.unwrapOptionField("tableColumnId", tableColumnId)
    def getTableColumnName: ZIO[Any, AwsError, TableColumnName] =
      AwsError.unwrapOptionField("tableColumnName", tableColumnName)
    def getFormat: ZIO[Any, AwsError, zio.aws.honeycode.model.Format] =
      AwsError.unwrapOptionField("format", format)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.TableColumn
  ) extends zio.aws.honeycode.model.TableColumn.ReadOnly {
    override val tableColumnId: Optional[ResourceId] = zio.aws.core.internal
      .optionalFromNullable(impl.tableColumnId())
      .map(value => zio.aws.honeycode.model.primitives.ResourceId(value))
    override val tableColumnName: Optional[TableColumnName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tableColumnName())
        .map(value => zio.aws.honeycode.model.primitives.TableColumnName(value))
    override val format: Optional[zio.aws.honeycode.model.Format] =
      zio.aws.core.internal
        .optionalFromNullable(impl.format())
        .map(value => zio.aws.honeycode.model.Format.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.TableColumn
  ): zio.aws.honeycode.model.TableColumn.ReadOnly = new Wrapper(impl)
}
