package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.honeycode.model.primitives.{AwsUserArn, Email}
import scala.jdk.CollectionConverters.*
final case class ImportJobSubmitter(
    email: Optional[Email] = Optional.Absent,
    userArn: Optional[AwsUserArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.ImportJobSubmitter = {
    import ImportJobSubmitter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.ImportJobSubmitter
      .builder()
      .optionallyWith(
        email.map(value => Email.unwrap(value): java.lang.String)
      )(_.email)
      .optionallyWith(
        userArn.map(value => AwsUserArn.unwrap(value): java.lang.String)
      )(_.userArn)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.ImportJobSubmitter.ReadOnly =
    zio.aws.honeycode.model.ImportJobSubmitter.wrap(buildAwsValue())
}
object ImportJobSubmitter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.ImportJobSubmitter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.ImportJobSubmitter =
      zio.aws.honeycode.model.ImportJobSubmitter(
        email.map(value => value),
        userArn.map(value => value)
      )
    def email: Optional[Email]
    def userArn: Optional[AwsUserArn]
    def getEmail: ZIO[Any, AwsError, Email] =
      AwsError.unwrapOptionField("email", email)
    def getUserArn: ZIO[Any, AwsError, AwsUserArn] =
      AwsError.unwrapOptionField("userArn", userArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.ImportJobSubmitter
  ) extends zio.aws.honeycode.model.ImportJobSubmitter.ReadOnly {
    override val email: Optional[Email] = zio.aws.core.internal
      .optionalFromNullable(impl.email())
      .map(value => zio.aws.honeycode.model.primitives.Email(value))
    override val userArn: Optional[AwsUserArn] = zio.aws.core.internal
      .optionalFromNullable(impl.userArn())
      .map(value => zio.aws.honeycode.model.primitives.AwsUserArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.ImportJobSubmitter
  ): zio.aws.honeycode.model.ImportJobSubmitter.ReadOnly = new Wrapper(impl)
}
