package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.honeycode.model.primitives.{FormattedValue, RawValue}
import scala.jdk.CollectionConverters.*
final case class DataItem(
    overrideFormat: Optional[zio.aws.honeycode.model.Format] = Optional.Absent,
    rawValue: Optional[RawValue] = Optional.Absent,
    formattedValue: Optional[FormattedValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.DataItem = {
    import DataItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.DataItem
      .builder()
      .optionallyWith(overrideFormat.map(value => value.unwrap))(
        _.overrideFormat
      )
      .optionallyWith(
        rawValue.map(value => RawValue.unwrap(value): java.lang.String)
      )(_.rawValue)
      .optionallyWith(
        formattedValue.map(value =>
          FormattedValue.unwrap(value): java.lang.String
        )
      )(_.formattedValue)
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.DataItem.ReadOnly =
    zio.aws.honeycode.model.DataItem.wrap(buildAwsValue())
}
object DataItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.DataItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.DataItem =
      zio.aws.honeycode.model.DataItem(
        overrideFormat.map(value => value),
        rawValue.map(value => value),
        formattedValue.map(value => value)
      )
    def overrideFormat: Optional[zio.aws.honeycode.model.Format]
    def rawValue: Optional[RawValue]
    def formattedValue: Optional[FormattedValue]
    def getOverrideFormat: ZIO[Any, AwsError, zio.aws.honeycode.model.Format] =
      AwsError.unwrapOptionField("overrideFormat", overrideFormat)
    def getRawValue: ZIO[Any, AwsError, RawValue] =
      AwsError.unwrapOptionField("rawValue", rawValue)
    def getFormattedValue: ZIO[Any, AwsError, FormattedValue] =
      AwsError.unwrapOptionField("formattedValue", formattedValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.DataItem
  ) extends zio.aws.honeycode.model.DataItem.ReadOnly {
    override val overrideFormat: Optional[zio.aws.honeycode.model.Format] =
      zio.aws.core.internal
        .optionalFromNullable(impl.overrideFormat())
        .map(value => zio.aws.honeycode.model.Format.wrap(value))
    override val rawValue: Optional[RawValue] = zio.aws.core.internal
      .optionalFromNullable(impl.rawValue())
      .map(value => zio.aws.honeycode.model.primitives.RawValue(value))
    override val formattedValue: Optional[FormattedValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.formattedValue())
        .map(value => zio.aws.honeycode.model.primitives.FormattedValue(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.DataItem
  ): zio.aws.honeycode.model.DataItem.ReadOnly = new Wrapper(impl)
}
