package zio.aws.honeycode.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.honeycode.model.primitives.{
  IgnoreEmptyRows,
  HasHeaderRow,
  DelimitedTextDelimiter
}
import scala.jdk.CollectionConverters.*
final case class DelimitedTextImportOptions(
    delimiter: DelimitedTextDelimiter,
    hasHeaderRow: Option[HasHeaderRow] = None,
    ignoreEmptyRows: Option[IgnoreEmptyRows] = None,
    dataCharacterEncoding: Option[
      zio.aws.honeycode.model.ImportDataCharacterEncoding
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.honeycode.model.DelimitedTextImportOptions = {
    import DelimitedTextImportOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.honeycode.model.DelimitedTextImportOptions
      .builder()
      .delimiter(DelimitedTextDelimiter.unwrap(delimiter): java.lang.String)
      .optionallyWith(
        hasHeaderRow.map(value => HasHeaderRow.unwrap(value): java.lang.Boolean)
      )(_.hasHeaderRow)
      .optionallyWith(
        ignoreEmptyRows.map(value =>
          IgnoreEmptyRows.unwrap(value): java.lang.Boolean
        )
      )(_.ignoreEmptyRows)
      .optionallyWith(dataCharacterEncoding.map(value => value.unwrap))(
        _.dataCharacterEncoding
      )
      .build()
  }
  def asReadOnly: zio.aws.honeycode.model.DelimitedTextImportOptions.ReadOnly =
    zio.aws.honeycode.model.DelimitedTextImportOptions.wrap(buildAwsValue())
}
object DelimitedTextImportOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.honeycode.model.DelimitedTextImportOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.honeycode.model.DelimitedTextImportOptions =
      zio.aws.honeycode.model.DelimitedTextImportOptions(
        delimiter,
        hasHeaderRow.map(value => value),
        ignoreEmptyRows.map(value => value),
        dataCharacterEncoding.map(value => value)
      )
    def delimiter: DelimitedTextDelimiter
    def hasHeaderRow: Option[HasHeaderRow]
    def ignoreEmptyRows: Option[IgnoreEmptyRows]
    def dataCharacterEncoding
        : Option[zio.aws.honeycode.model.ImportDataCharacterEncoding]
    def getDelimiter: ZIO[Any, Nothing, DelimitedTextDelimiter] =
      ZIO.succeed(delimiter)
    def getHasHeaderRow: ZIO[Any, AwsError, HasHeaderRow] =
      AwsError.unwrapOptionField("hasHeaderRow", hasHeaderRow)
    def getIgnoreEmptyRows: ZIO[Any, AwsError, IgnoreEmptyRows] =
      AwsError.unwrapOptionField("ignoreEmptyRows", ignoreEmptyRows)
    def getDataCharacterEncoding: ZIO[
      Any,
      AwsError,
      zio.aws.honeycode.model.ImportDataCharacterEncoding
    ] =
      AwsError.unwrapOptionField("dataCharacterEncoding", dataCharacterEncoding)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.honeycode.model.DelimitedTextImportOptions
  ) extends zio.aws.honeycode.model.DelimitedTextImportOptions.ReadOnly {
    override val delimiter: DelimitedTextDelimiter =
      zio.aws.honeycode.model.primitives
        .DelimitedTextDelimiter(impl.delimiter())
    override val hasHeaderRow: Option[HasHeaderRow] = scala
      .Option(impl.hasHeaderRow())
      .map(value => zio.aws.honeycode.model.primitives.HasHeaderRow(value))
    override val ignoreEmptyRows: Option[IgnoreEmptyRows] = scala
      .Option(impl.ignoreEmptyRows())
      .map(value => zio.aws.honeycode.model.primitives.IgnoreEmptyRows(value))
    override val dataCharacterEncoding
        : Option[zio.aws.honeycode.model.ImportDataCharacterEncoding] = scala
      .Option(impl.dataCharacterEncoding())
      .map(value =>
        zio.aws.honeycode.model.ImportDataCharacterEncoding.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.honeycode.model.DelimitedTextImportOptions
  ): zio.aws.honeycode.model.DelimitedTextImportOptions.ReadOnly = new Wrapper(
    impl
  )
}
